/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.module.ModuleUnits;

public class S3MUnits
implements ModuleUnits {
    private static final String NAME = "s3m";
    private double c4hz;
    private boolean amigaPeriods;
    private static final int MAX_PERIOD = 1712;
    private static final int MIN_PERIOD = 57;
    private static final double STANDARD_C4HZ = 8363.0;
    private double ac;

    public S3MUnits(int n, boolean bl) {
        this.c4hz = n;
        this.amigaPeriods = bl;
        this.ac = 7159090.5 * (double)n / 8363.0;
    }

    @Override
    public double note2period(double d) {
        return this.rate2period(this.note2rate(d));
    }

    @Override
    public double period2note(double d) {
        return this.rate2note(this.period2rate(d));
    }

    public double period2rate(double d) {
        return this.ac / (this.amigaPeriods ? d * 2.0 : d * 2.0);
    }

    public double rate2period(double d) {
        return this.ac / (this.amigaPeriods ? d * 2.0 : d * 2.0);
    }

    @Override
    public double note2rate(double d) {
        double d2 = this.c4hz / 16.0;
        return d2 * Math.pow(2.0, d / 12.0);
    }

    @Override
    public double rate2note(double d) {
        double d2 = this.c4hz / 16.0;
        return 12.0 * Math.log(d / d2) / Math.log(2.0);
    }

    @Override
    public double getUpperNoteLimit() {
        return this.period2note(57.0);
    }

    @Override
    public double getLowerNoteLimit() {
        return this.period2note(1712.0);
    }

    @Override
    public double addPeriod(double d, double d2) {
        return this.period2note(this.note2period(d) + d2);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

