/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.module.ModuleUnits;

public class STMUnits
implements ModuleUnits {
    private static final String NAME = "stm";
    private double c3hz;
    private static final double root2_12 = 1.059463094;
    private static final double c3 = 48.0;

    public STMUnits(int n) {
        this.c3hz = n;
    }

    @Override
    public double period2note(double d) {
        return this.rate2note(d);
    }

    @Override
    public double note2period(double d) {
        return this.note2rate(d);
    }

    @Override
    public double note2rate(double d) {
        double d2 = d - 48.0;
        return this.c3hz * Math.pow(1.059463094, d2);
    }

    @Override
    public double rate2note(double d) {
        return Math.log(d / this.c3hz) / Math.log(1.059463094) + 48.0;
    }

    @Override
    public double addPeriod(double d, double d2) {
        return this.period2note(this.note2period(d) + d2);
    }

    @Override
    public double getUpperNoteLimit() {
        return 120.0;
    }

    @Override
    public double getLowerNoteLimit() {
        return 0.0;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

