/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.loader.XmUnits;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.ModuleUnits;
import com.vwp.sound.mod.modplay.module.Pattern;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoVibrato;
import com.vwp.sound.mod.modplay.player.autoeffect.Fadeout;
import com.vwp.sound.mod.modplay.player.autoeffect.PanningEnvelope;
import com.vwp.sound.mod.modplay.player.autoeffect.VolumeEnvelope;
import com.vwp.sound.mod.modplay.player.autoeffect.XmAutoEffects;
import com.vwp.sound.mod.util.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class XMLoader
extends ModuleLoader {
    private Module module;

    public XMLoader(String string, byte[] byArray) throws InvalidFormatException, IOException {
        this.module = this.load(string, byArray);
    }

    private Module load(String string, byte[] byArray) throws InvalidFormatException, IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string2 = Util.readZeroPaddedString(dataInputStream, 17);
        String string3 = Util.readZeroPaddedString(dataInputStream, 20);
        XMLoader.skip(dataInputStream, 1);
        String string4 = Util.readZeroPaddedString(dataInputStream, 20);
        byte by = dataInputStream.readByte();
        byte by2 = dataInputStream.readByte();
        if (by2 != 1 || by < 4) {
            throw new InvalidFormatException("Unknown version: " + by2 + "." + by);
        }
        Util.readLEInt(dataInputStream);
        int n2 = Util.readLEShort(dataInputStream);
        int n3 = Util.readLEShort(dataInputStream);
        int n4 = Util.readLEShort(dataInputStream);
        int n5 = Util.readLEShort(dataInputStream);
        int n6 = Util.readLEShort(dataInputStream);
        Util.readLEShort(dataInputStream);
        int n7 = Util.readLEShort(dataInputStream);
        if (n7 == 0) {
            n7 = 1;
        }
        int n8 = Util.readLEShort(dataInputStream);
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = dataInputStream.readByte() & 0xFF;
        }
        XMLoader.skip(dataInputStream, 256 - n2);
        Instrument[] instrumentArray = this.loadInstruments(byArray, n6);
        int n9 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n9) continue;
            n9 = nArray[i];
        }
        Pattern[] patternArray = new Pattern[Math.max(n9 + 1, n5)];
        for (n = 0; n < n5; ++n) {
            patternArray[n] = this.loadPattern(dataInputStream, n4);
        }
        for (n = n5; n <= n9; ++n) {
            Track[] trackArray = new Track[n4];
            for (int i = 0; i < n4; ++i) {
                trackArray[i] = new Track(64);
                for (int j = 0; j < 64; ++j) {
                    trackArray[i].initDivision(j, -1, -2, null, null, null);
                }
            }
            patternArray[n] = new Pattern(trackArray, 64);
        }
        double d = 1.0;
        double d2 = 0.0;
        double[] dArray = new double[]{d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2};
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray2[i] = dArray[i];
            dArray3[i] = 1.0;
        }
        this.module = new Module(string3, string2, string4, instrumentArray, patternArray, nArray, n3, n8, n7, 1.0, 2, dArray3, dArray2);
        return this.module;
    }

    private Instrument[] loadInstruments(byte[] byArray, int n) throws IOException {
        int n2;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        XMLoader.skip(dataInputStream, 60);
        int n3 = Util.readLEInt(dataInputStream);
        XMLoader.skip(dataInputStream, 6);
        int n4 = Util.readLEShort(dataInputStream);
        XMLoader.skip(dataInputStream, n3 - 12);
        for (int i = 0; i < n4; ++i) {
            XMLoader.skip(dataInputStream, 7);
            n2 = Util.readLEShort(dataInputStream);
            XMLoader.skip(dataInputStream, n2);
        }
        Instrument[] instrumentArray = new Instrument[n];
        for (n2 = 0; n2 < n; ++n2) {
            int n5;
            Object object;
            int n6;
            byte by;
            int n7;
            short s;
            int n8;
            int n9;
            int n10;
            Object object2;
            Object[] objectArray;
            Sample[] sampleArray;
            int n11 = Util.readLEInt(dataInputStream);
            String string = Util.readZeroPaddedString(dataInputStream, 22);
            dataInputStream.readByte();
            int n12 = Util.readLEShort(dataInputStream);
            int[] nArray = null;
            AutoEffect[] autoEffectArray = null;
            if (n12 > 0) {
                XMLoader.skip(dataInputStream, 4);
                nArray = new int[98];
                for (int i = 0; i < 96; ++i) {
                    nArray[i] = dataInputStream.readByte() & 0xFF;
                }
                sampleArray = (Sample[])new int[12];
                objectArray = new double[12];
                for (int i = 0; i < 12; ++i) {
                    sampleArray[i] = (Sample)Util.readLEShort(dataInputStream);
                    objectArray[i] = (int)((double)Util.readLEShort(dataInputStream) / 64.0);
                }
                object2 = new int[12];
                double[] dArray = new double[12];
                for (n10 = 0; n10 < 12; ++n10) {
                    object2[n10] = Util.readLEShort(dataInputStream);
                    dArray[n10] = (double)Util.readLEShort(dataInputStream) / 64.0;
                }
                n10 = dataInputStream.readByte();
                n9 = dataInputStream.readByte();
                n8 = dataInputStream.readByte();
                s = dataInputStream.readByte();
                n7 = dataInputStream.readByte();
                byte by2 = dataInputStream.readByte();
                byte by3 = dataInputStream.readByte();
                by = dataInputStream.readByte();
                n6 = dataInputStream.readByte();
                byte by4 = dataInputStream.readByte();
                VolumeEnvelope volumeEnvelope = new VolumeEnvelope((int[])sampleArray, (double[])objectArray, n10, n8, s, n7, n6);
                PanningEnvelope panningEnvelope = new PanningEnvelope((int[])object2, dArray, n9, by2, by3, by, by4);
                object = new AutoVibrato(dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte());
                double d = (double)(Util.readLEShort(dataInputStream) & 0xFFFF) / 32768.0;
                Fadeout fadeout = new Fadeout(d);
                XmAutoEffects xmAutoEffects = new XmAutoEffects(volumeEnvelope, panningEnvelope, (AutoVibrato)object, fadeout);
                autoEffectArray = new AutoEffect[]{xmAutoEffects};
                XMLoader.skip(dataInputStream, 2);
                XMLoader.skip(dataInputStream, n11 - 243);
            } else {
                XMLoader.skip(dataInputStream, n11 - 29);
            }
            sampleArray = null;
            if (n12 > 0) {
                sampleArray = new Sample[n12];
            }
            objectArray = new int[n12];
            object2 = new XmUnits();
            for (n5 = 0; n5 < n12; ++n5) {
                n10 = Util.readLEInt(dataInputStream);
                n9 = Util.readLEInt(dataInputStream);
                n8 = Util.readLEInt(dataInputStream);
                double d = (double)dataInputStream.readByte() / 64.0;
                double d2 = (double)dataInputStream.readByte() / 128.0;
                objectArray[n5] = dataInputStream.readByte();
                if ((by & 3) == 0) {
                    n8 = 0;
                    n9 = 0;
                }
                n6 = (dataInputStream.readByte() & 0xFF) - 128;
                double d3 = ((double)n6 / 128.0 + 1.0) / 2.0;
                byte by5 = dataInputStream.readByte();
                dataInputStream.readByte();
                object = Util.readZeroPaddedString(dataInputStream, 22);
                int n13 = 0;
                if ((by & 3) == 0 || n8 == 0) {
                    n13 = 0;
                } else if ((by & 3) == 1) {
                    n13 = 1;
                } else if ((by & 3) == 2) {
                    n13 = 2;
                }
                if ((by & 0x10) != 0) {
                    n10 /= 2;
                    n9 /= 2;
                    n8 /= 2;
                }
                sampleArray[n5] = new Sample("sample-" + n2 + "-" + n5, (String)object, d, d3, n10, n13, n9, n8, by5, d2, (ModuleUnits)object2);
            }
            for (n5 = 0; n5 < n12; ++n5) {
                short[] sArray;
                n10 = sampleArray[n5].getLength();
                if ((objectArray[n5] & 0x10) != 0) {
                    sArray = new short[n10];
                    n8 = 0;
                    for (n7 = 0; n7 < n10; ++n7) {
                        sArray[n7] = s = (short)(n8 + (short)Util.readLEShort(dataInputStream));
                        n8 = s;
                    }
                } else {
                    sArray = new short[n10];
                    n8 = 0;
                    for (s = 0; s < n10; s = (short)(s + 1)) {
                        sArray[s] = n7 = (int)((short)(n8 + dataInputStream.readByte() * 256));
                        n8 = n7;
                    }
                }
                sampleArray[n5].setData(sArray);
            }
            instrumentArray[n2] = new Instrument(string, nArray, sampleArray, autoEffectArray, 0.0);
        }
        return instrumentArray;
    }

    private Pattern loadPattern(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        Util.readLEInt(dataInputStream);
        dataInputStream.readByte();
        int n3 = Util.readLEShort(dataInputStream);
        int n4 = Util.readLEShort(dataInputStream);
        Track[] trackArray = new Track[n];
        for (n2 = 0; n2 < n; ++n2) {
            trackArray[n2] = new Track(n3);
        }
        n2 = 0;
        int n5 = 0;
        if (n4 == 0) {
            Track[] trackArray2 = new Track[n];
            for (int i = 0; i < n; ++i) {
                trackArray2[i] = new Track(64);
                for (int j = 0; j < 64; ++j) {
                    trackArray2[i].initDivision(j, -1, -2, null, null, null);
                }
            }
            return new Pattern(trackArray2, 64);
        }
        while (n5 < n4) {
            for (int i = 0; i < n; ++i) {
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                byte by = dataInputStream.readByte();
                ++n5;
                if (by >= 0) {
                    n7 = by & 0xFF;
                    n8 = dataInputStream.readByte() & 0xFF;
                    ++n5;
                    n9 = dataInputStream.readByte() & 0xFF;
                    ++n5;
                    n10 = dataInputStream.readByte() & 0xFF;
                    ++n5;
                    n11 = dataInputStream.readByte() & 0xFF;
                    ++n5;
                } else {
                    if ((by & 1) != 0) {
                        n7 = dataInputStream.readByte() & 0xFF;
                        ++n5;
                    }
                    if ((by & 2) != 0) {
                        n8 = dataInputStream.readByte() & 0xFF;
                        ++n5;
                    }
                    if ((by & 4) != 0) {
                        n9 = dataInputStream.readByte() & 0xFF;
                        ++n5;
                    }
                    if ((by & 8) != 0) {
                        n10 = dataInputStream.readByte() & 0xFF;
                        ++n5;
                    }
                    if ((by & 0x10) != 0) {
                        n11 = dataInputStream.readByte() & 0xFF;
                        ++n5;
                    }
                }
                boolean bl = false;
                if (n7 == 0) {
                    n7 = -2;
                } else if (n7 == 97) {
                    bl = true;
                    n7 = -2;
                } else {
                    --n7;
                }
                n8 = n8 == 0 ? -1 : --n8;
                if (n10 != 0 || n11 != 0) {
                    ++n6;
                }
                if (n9 >= 16) {
                    ++n6;
                }
                if (bl) {
                    ++n6;
                }
                int[] nArray = new int[n6];
                int[] nArray2 = new int[n6];
                int[] nArray3 = new int[n6];
                int n12 = 0;
                if (n9 >= 16 && n9 <= 80) {
                    nArray[n12] = 12;
                    nArray2[n12] = n9 - 16 >>> 4 & 0xF;
                    nArray3[n12] = n9 - 16 & 0xF;
                    ++n12;
                } else if (n9 >= 96 && n9 <= 111) {
                    nArray[n12] = 10;
                    nArray2[n12] = 0;
                    nArray3[n12] = n9 & 0xF;
                    ++n12;
                } else if (n9 >= 112 && n9 <= 127) {
                    nArray[n12] = 10;
                    nArray2[n12] = n9 & 0xF;
                    nArray3[n12] = 0;
                    ++n12;
                } else if (n9 >= 128 && n9 <= 143) {
                    nArray[n12] = 27;
                    nArray2[n12] = 11;
                    nArray3[n12] = n9 & 0xF;
                    ++n12;
                } else if (n9 >= 144 && n9 <= 159) {
                    nArray[n12] = 26;
                    nArray2[n12] = 10;
                    nArray3[n12] = n9 & 0xF;
                    ++n12;
                } else if (n9 >= 160 && n9 <= 175) {
                    nArray[n12] = 4;
                    nArray2[n12] = n9 & 0xF;
                    nArray3[n12] = 0;
                    ++n12;
                } else if (n9 >= 176 && n9 <= 191) {
                    nArray[n12] = 4;
                    nArray2[n12] = 0;
                    nArray3[n12] = n9 & 0xF;
                    ++n12;
                } else if (n9 >= 192 && n9 <= 207) {
                    nArray[n12] = 8;
                    nArray2[n12] = n9 & 0xF;
                    nArray3[n12] = 0;
                    ++n12;
                } else if (n9 >= 208 && n9 <= 223) {
                    nArray[n12] = 52;
                    nArray2[n12] = 0;
                    nArray3[n12] = n9 & 0xF;
                    ++n12;
                } else if (n9 >= 224 && n9 <= 239) {
                    nArray[n12] = 52;
                    nArray2[n12] = n9 & 0xF;
                    nArray3[n12] = 0;
                    ++n12;
                } else if (n9 >= 240 && n9 <= 255) {
                    nArray[n12] = 3;
                    nArray2[n12] = 0;
                    nArray3[n12] = n9 & 0xF;
                    ++n12;
                } else if (bl) {
                    nArray[n12] = 50;
                    nArray2[n12] = 0;
                    nArray3[n12] = 0;
                    ++n12;
                }
                if (n10 != 0 || n11 != 0) {
                    int n13 = n11 >>> 4 & 0xF;
                    int n14 = n11 & 0xF;
                    nArray[n12] = this.translateEffectNum(n10, n13);
                    nArray2[n12] = n13;
                    nArray3[n12] = n14;
                    ++n12;
                }
                trackArray[i].initDivision(n2, n8, n7, nArray, nArray2, nArray3);
            }
            ++n2;
        }
        return new Pattern(trackArray, n3);
    }

    private int translateEffectNum(int n, int n2) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 41;
            }
            case 3: {
                return 42;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 43;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                switch (n2) {
                    case 0: {
                        return 16;
                    }
                    case 1: {
                        return 44;
                    }
                    case 2: {
                        return 45;
                    }
                    case 3: {
                        return 19;
                    }
                    case 4: {
                        return 20;
                    }
                    case 5: {
                        return 21;
                    }
                    case 6: {
                        return 22;
                    }
                    case 7: {
                        return 23;
                    }
                    case 8: {
                        return 24;
                    }
                    case 9: {
                        return 25;
                    }
                    case 10: {
                        return 46;
                    }
                    case 11: {
                        return 47;
                    }
                    case 12: {
                        return 28;
                    }
                    case 13: {
                        return 29;
                    }
                    case 14: {
                        return 30;
                    }
                    case 15: {
                        return 31;
                    }
                }
                break;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 48;
            }
            case 17: {
                return 49;
            }
            case 20: {
                return 50;
            }
            case 21: {
                return 51;
            }
            case 25: {
                return 52;
            }
            case 27: {
                return 53;
            }
            case 29: {
                return 60;
            }
            case 32: {
                return 54;
            }
            case 33: {
                if (n2 == 1) {
                    return 55;
                }
                if (n2 != 2) break;
                return 56;
            }
        }
        System.err.println("Bad effect number: " + n);
        return -1;
    }

    @Override
    public Module getModule() {
        return this.module;
    }
}

