/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.module.ModuleUnits;

public class XmUnits
implements ModuleUnits {
    private static final String NAME = "xm";
    private static double maxNote;
    private static double minNote;
    public static final double MAX_NOTE = 96.0;
    public static final double MIN_NOTE = 0.0;

    public XmUnits() {
        maxNote = 96.0;
        minNote = 0.0;
    }

    public double period2rate(double d) {
        return 8363.0 * Math.pow(2.0, (4608.0 - d) / 768.0);
    }

    public double rate2period(double d) {
        return -768.0 * Math.log(d / 8363.0) / Math.log(2.0) + 4608.0;
    }

    @Override
    public double period2note(double d) {
        return (d - 7680.0) / -64.0;
    }

    @Override
    public double note2period(double d) {
        return 7680.0 - d * 16.0 * 4.0;
    }

    @Override
    public double note2rate(double d) {
        return this.period2rate(this.note2period(d));
    }

    @Override
    public double rate2note(double d) {
        return this.period2note(this.rate2period(d));
    }

    @Override
    public double addPeriod(double d, double d2) {
        return this.period2note(this.note2period(d) + d2);
    }

    @Override
    public double getUpperNoteLimit() {
        return maxNote;
    }

    @Override
    public double getLowerNoteLimit() {
        return minNote;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

