/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.module;

import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;

public class Instrument {
    private String name;
    private Sample[] samples;
    private int[] note2sample;
    private AutoEffect[] autoEffects;
    private double panning;
    public static final int NO_NOTE = -2;

    public Instrument(String string, int[] nArray, Sample[] sampleArray, AutoEffect[] autoEffectArray, double d) {
        this.name = string;
        this.note2sample = nArray;
        this.samples = sampleArray;
        this.autoEffects = autoEffectArray;
        this.panning = d;
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Instrument name: ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        stringBuffer.append("#samples:        ");
        stringBuffer.append(this.getNumberOfSamples());
        stringBuffer.append("\n");
        for (int i = 0; i < this.getNumberOfSamples(); ++i) {
            stringBuffer.append(this.samples[i].getInfo());
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public Sample getSampleByNum(int n) {
        if (n > this.samples.length || n < 0) {
            return null;
        }
        return this.samples[n];
    }

    public Sample getSampleByNote(int n) {
        if (n == -2 || this.note2sample == null || n >= this.note2sample.length || n < 0) {
            return null;
        }
        return this.samples[this.note2sample[n]];
    }

    public int getNumberOfSamples() {
        if (this.samples == null) {
            return 0;
        }
        return this.samples.length;
    }

    public int getNumberOfAutoEffects() {
        if (this.autoEffects == null) {
            return 0;
        }
        return this.autoEffects.length;
    }

    public AutoEffect getAutoEffect(int n) {
        if (this.autoEffects == null || n >= this.autoEffects.length || n < 0) {
            return null;
        }
        return this.autoEffects[n];
    }

    public AutoEffect[] getAutoEffects() {
        return this.autoEffects;
    }

    public double getPanning() {
        return this.panning;
    }
}

