/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.module;

import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Pattern;
import java.util.HashMap;
import java.util.Map;

public class Module {
    private String name;
    private String id;
    private String tracker;
    private String description;
    private Instrument[] instruments;
    private Pattern[] patterns;
    private int[] patternOrder;
    private int restartPos;
    private int initialBPM;
    private int initialSpeed;
    private double initialVolume;
    private double[] initialPanning;
    private double[] initialTrackVolume;
    private int panningType;
    private Map properties = new HashMap();
    public static final int TRACK_PANNING = 1;
    public static final int SAMPLE_PANNING = 2;
    public static final int INSTRUMENT_PANNING = 3;

    public Module(String string, String string2, String string3, Instrument[] instrumentArray, Pattern[] patternArray, int[] nArray, int n, int n2, int n3, double d, int n4, double[] dArray, double[] dArray2) {
        this.name = string;
        this.id = string2;
        this.tracker = string3;
        this.instruments = instrumentArray;
        this.patterns = patternArray;
        this.patternOrder = nArray;
        this.restartPos = n;
        this.initialBPM = n2;
        this.initialSpeed = n3;
        this.initialVolume = d;
        this.panningType = n4;
        this.initialTrackVolume = dArray;
        this.initialPanning = dArray2;
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name:    ");
        stringBuffer.append(this.pad(this.getName(), 25, ' '));
        stringBuffer.append(" Chan: ");
        stringBuffer.append(this.pad(this.getPatternAtPos(0).getTrackCount() + "", 3, ' '));
        stringBuffer.append(" Pos: ");
        stringBuffer.append(this.getNumberOfPositions());
        stringBuffer.append("\n");
        stringBuffer.append("Type:    ");
        stringBuffer.append(this.pad(this.getId(), 25, ' '));
        stringBuffer.append(" Inst: ");
        stringBuffer.append(this.pad(this.getNumberOfInstruments() + "", 3, ' '));
        stringBuffer.append(" Pat: ");
        stringBuffer.append(this.getNumberOfPatterns());
        stringBuffer.append("\n");
        stringBuffer.append("Tracker: ");
        stringBuffer.append(this.getTracker());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String pad(String string, int n, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > n) {
            stringBuffer.append(string.substring(0, n));
        } else {
            stringBuffer.append(string);
        }
        while (stringBuffer.length() < n) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getTracker() {
        return this.tracker;
    }

    public int getNumberOfInstruments() {
        return this.instruments.length;
    }

    public Instrument getInstrument(int n) {
        if (n >= this.instruments.length || n < 0) {
            return null;
        }
        return this.instruments[n];
    }

    public Instrument[] getInstruments() {
        return this.instruments;
    }

    public int getNumberOfPatterns() {
        return this.patterns.length;
    }

    public int getNumberOfPositions() {
        return this.patternOrder.length;
    }

    public int getPatternIndexAtPos(int n) {
        return this.patternOrder[n];
    }

    public Pattern getPattern(int n) {
        return this.patterns[n];
    }

    public Pattern getPatternAtPos(int n) {
        return this.getPattern(this.getPatternIndexAtPos(n));
    }

    public int getRestartPos() {
        return this.restartPos;
    }

    public int getInitialBpm() {
        return this.initialBPM;
    }

    public int getInitialSpeed() {
        return this.initialSpeed;
    }

    public double getInitialVolume() {
        return this.initialVolume;
    }

    public int getPanningType() {
        return this.panningType;
    }

    public double getInitialVolume(int n) {
        return this.initialTrackVolume[n];
    }

    public double getInitialPanning(int n) {
        return this.initialPanning[n];
    }

    public int getTrackCount() {
        return this.getPatternAtPos(0).getTrackCount();
    }
}

