/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.module;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.module.ModInfo;
import com.vwp.sound.mod.modplay.module.S3MInfo;
import com.vwp.sound.mod.modplay.module.XMInfo;
import com.vwp.sound.mod.util.io.RandomAccess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class ModuleInfo {
    private String type;
    private String fileName;
    private String name;
    private String id;
    private String tracker;
    private int instrumentCount;
    private int trackCount;
    private int patternCount;
    private int positionCount;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        if (this.name.trim().length() > 0) {
            return this.name;
        }
        return new File(this.getFileName()).getName();
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setTracker(String string) {
        this.tracker = string;
    }

    public String getTracker() {
        return this.tracker;
    }

    public void setInstrumentCount(int n) {
        this.instrumentCount = n;
    }

    public int getInstrumentCount() {
        return this.instrumentCount;
    }

    public void setPatternCount(int n) {
        this.patternCount = n;
    }

    public int getPatternCount() {
        return this.patternCount;
    }

    public void setPositionCount(int n) {
        this.positionCount = n;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public void setTrackCount(int n) {
        this.trackCount = n;
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public static ModuleInfo get(String string) throws InvalidFormatException, FileNotFoundException {
        ModuleInfo moduleInfo = null;
        if (string.toLowerCase().endsWith(".mod")) {
            moduleInfo = new ModInfo();
        } else if (string.toLowerCase().endsWith(".xm")) {
            moduleInfo = new XMInfo();
        } else if (string.toLowerCase().endsWith(".s3m")) {
            moduleInfo = new S3MInfo();
        }
        ((ModuleInfo)moduleInfo).load(string);
        return moduleInfo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo moduleInfo = (ModuleInfo)object;
        return this.getFileName().equals(moduleInfo.getFileName());
    }

    protected abstract void load(String var1) throws InvalidFormatException, FileNotFoundException;

    public String toString() {
        return ModuleInfo.pad("[" + this.getType() + "]", 5, ' ', true) + "  " + ModuleInfo.pad(ModuleInfo.shorten(this.getName().trim(), 25), 25, ' ', true) + " " + ModuleInfo.pad(this.getPositionCount() + "", 4, ' ', false);
    }

    private static String pad(String string, int n, char c, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        int n2 = string.length();
        while (n2++ < n) {
            if (bl) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.insert(0, c);
        }
        return stringBuffer.toString();
    }

    private static String shorten(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n - 3) + "...";
    }

    protected String readStringZ(RandomAccess randomAccess, int n) throws IOException {
        int n2 = n;
        int n3 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2-- > 0 && (n3 = randomAccess.read()) != 0) {
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    protected int readShort(RandomAccess randomAccess) throws IOException {
        int n = randomAccess.readUnsignedByte();
        int n2 = randomAccess.readUnsignedByte();
        return (n2 << 8) + n;
    }
}

