/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.module;

import com.vwp.sound.mod.util.Util;

public class Track {
    private int[] instruments;
    private int[] notes;
    private int[][] effects;
    private int[][] effectArg1;
    private int[][] effectArg2;
    public static final int NO_INSTRUMENT = -1;

    public Track(int n) {
        this.instruments = new int[n];
        this.notes = new int[n];
        this.effects = new int[n][];
        this.effectArg1 = new int[n][];
        this.effectArg2 = new int[n][];
    }

    public void initDivision(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        this.instruments[n] = n2;
        this.notes[n] = n3;
        this.effects[n] = nArray;
        this.effectArg1[n] = nArray2;
        this.effectArg2[n] = nArray3;
    }

    public int getInstrumentNumber(int n) {
        return this.instruments[n];
    }

    public int getNote(int n) {
        return this.notes[n];
    }

    public int getNumberOfEffects(int n) {
        if (this.effects[n] != null) {
            return this.effects[n].length;
        }
        return 0;
    }

    public int getEffect(int n, int n2) {
        return this.effects[n][n2];
    }

    public int getEffectArg1(int n, int n2) {
        return this.effectArg1[n][n2];
    }

    public int getEffectArg2(int n, int n2) {
        return this.effectArg2[n][n2];
    }

    public String getInfo(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNoteSymbol(n) + " ");
        stringBuffer.append(this.getInstrumentSymbol(n) + " ");
        for (n2 = 0; n2 < this.getNumberOfEffects(n); ++n2) {
            stringBuffer.append(this.getEffectSymbol(n, n2) + " ");
        }
        for (n2 = this.getNumberOfEffects(n); n2 < 2; ++n2) {
            stringBuffer.append("--- ");
        }
        return stringBuffer.toString();
    }

    private String getNoteSymbol(int n) {
        int n2 = this.notes[n];
        if (n2 == -2) {
            return "---";
        }
        int n3 = n2 % 12;
        int n4 = n2 / 12;
        String string = null;
        switch (n3) {
            case 0: {
                string = "C-";
                break;
            }
            case 1: {
                string = "C#";
                break;
            }
            case 2: {
                string = "D-";
                break;
            }
            case 3: {
                string = "D#";
                break;
            }
            case 4: {
                string = "E-";
                break;
            }
            case 5: {
                string = "F-";
                break;
            }
            case 6: {
                string = "F#";
                break;
            }
            case 7: {
                string = "G-";
                break;
            }
            case 8: {
                string = "G#";
                break;
            }
            case 9: {
                string = "A-";
                break;
            }
            case 10: {
                string = "A#";
                break;
            }
            case 11: {
                string = "B-";
                break;
            }
            default: {
                string = "XX";
            }
        }
        string = string + n4;
        return string;
    }

    private String getInstrumentSymbol(int n) {
        return Util.nibbleToHex(this.instruments[n] >> 4) + Util.nibbleToHex(this.instruments[n]);
    }

    private String getEffectSymbol(int n, int n2) {
        return Util.nibbleToHex(this.effects[n][n2]) + Util.nibbleToHex(this.effectArg1[n][n2]) + Util.nibbleToHex(this.effectArg2[n][n2]);
    }
}

