/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player;

import com.vwp.sound.mod.modplay.player.LowLevelMixer;
import com.vwp.sound.mod.modplay.player.Mixer;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.sound.output.Output;
import java.io.IOException;

public class DefaultMixer
implements Mixer {
    private int[] mixerBufferLeft = new int[44100];
    private int[] mixerBufferRight = new int[44100];
    private byte[] mixedData = new byte[352800];
    private Output output;
    private Class lowLevelMixerClass;
    private int numberOfTracks;
    private double amplification = 1.0;
    private double volume = 1.0;
    private double balance = 0.5;
    private double separation = 1.0;
    private Track[] tracks;

    public DefaultMixer(Output output, Class clazz, int n) {
        this.lowLevelMixerClass = clazz;
        this.output = output;
        this.numberOfTracks = n;
        this.tracks = new Track[n];
        for (int i = 0; i < n; ++i) {
            this.tracks[i] = new Track();
        }
    }

    @Override
    public void setTrack(short[] sArray, double d, double d2, double d3, double d4, int n, int n2, int n3, int n4) throws PlayerException {
        try {
            if (this.tracks[n4] == null) {
                this.tracks[n4] = new Track((LowLevelMixer)this.lowLevelMixerClass.newInstance(), sArray, d, d2, d3, d4, n, n2, n3);
            } else {
                this.tracks[n4].init((LowLevelMixer)this.lowLevelMixerClass.newInstance(), sArray, d, d2, d3, d4, n, n2, n3);
            }
        }
        catch (Exception exception) {
            throw new PlayerException("Could not initialize track " + n4);
        }
    }

    @Override
    public int getNumberOfTracks() {
        return this.numberOfTracks;
    }

    @Override
    public void setAmplification(double d) {
        this.amplification = d;
    }

    @Override
    public double getAmplification() {
        return this.amplification;
    }

    @Override
    public void setVolume(double d) {
        if (d > 1.0) {
            d = 1.0;
        } else if (d < 0.0) {
            d = 0.0;
        }
        this.volume = d;
    }

    @Override
    public double getVolume() {
        return this.volume;
    }

    @Override
    public void setBalance(double d) {
        this.balance = d;
    }

    @Override
    public double getBalance() {
        return this.balance;
    }

    @Override
    public void setSeparation(double d) {
        this.separation = d;
    }

    @Override
    public double getSeparation() {
        return this.separation;
    }

    @Override
    public void setMute(int n, boolean bl) {
        if (this.tracks[n] != null) {
            this.tracks[n].setMute(bl);
        }
    }

    @Override
    public boolean isMute(int n) {
        return this.tracks[n].isMute();
    }

    @Override
    public void play(double d) throws PlayerException {
        try {
            int n = (int)(d * 44100.0 / 1000.0) * 2 * 2;
            this.mix(this.mixedData, n);
            this.output.write(this.mixedData, 0, n);
        }
        catch (IOException iOException) {
            throw new PlayerException("Could not ply mixed data");
        }
    }

    private void mix(byte[] byArray, int n) {
        double d;
        int n2 = n / 4;
        for (int i = 0; i < this.numberOfTracks; ++i) {
            if (this.tracks[i] == null) continue;
            this.tracks[i].mix(n2, 1);
            this.tracks[i].mix(n2, 2);
        }
        double d2 = d = this.amplification * this.volume / (double)this.numberOfTracks;
        if (this.balance < 0.5) {
            d2 *= 2.0 * this.balance;
        } else if (this.balance > 0.5) {
            d *= 2.0 * (1.0 - this.balance);
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            double d3 = (double)this.mixerBufferRight[n4] * d2;
            if (d3 > 32767.0) {
                d3 = 32767.0;
            } else if (d3 < -32768.0) {
                d3 = -32768.0;
            }
            double d4 = (double)this.mixerBufferLeft[n4] * d;
            if (d4 > 32767.0) {
                d4 = 32767.0;
            } else if (d4 < -32768.0) {
                d4 = -32768.0;
            }
            int n5 = (int)(d3 * this.separation + d4 * (1.0 - this.separation));
            int n6 = (int)(d4 * this.separation + d3 * (1.0 - this.separation));
            byArray[n3 + 0] = (byte)n6;
            byArray[n3 + 1] = (byte)(n6 >>> 8);
            byArray[n3 + 2] = (byte)n5;
            byArray[n3 + 3] = (byte)(n5 >>> 8);
            n3 += 4;
            ++n4;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.mixerBufferLeft[n3] = 0;
            this.mixerBufferRight[n3] = 0;
        }
    }

    private class Track {
        public static final int LEFT = 1;
        public static final int RIGHT = 2;
        public static final int MONO = 3;
        private short[] sampleData;
        private double offset;
        private double offsetLeft;
        private double offsetRight;
        private double rate;
        private double volume;
        private double panning;
        private int loopType;
        private int loopStart;
        private int loopLength;
        private boolean mute = false;
        private LowLevelMixer llm;
        int TBL = 256;
        short[] tmpBuffer = new short[this.TBL];
        int tmpBufferStart = 0;
        int tmpBufferEnd = 0;

        public Track() {
        }

        public Track(LowLevelMixer lowLevelMixer, short[] sArray, double d, double d2, double d3, double d4, int n, int n2, int n3) {
            this.init(lowLevelMixer, sArray, d, d2, d3, d4, n, n2, n3);
        }

        public void init(LowLevelMixer lowLevelMixer, short[] sArray, double d, double d2, double d3, double d4, int n, int n2, int n3) {
            this.llm = lowLevelMixer;
            this.sampleData = sArray;
            this.offsetLeft = this.offsetRight = d;
            this.offset = this.offsetRight;
            this.rate = d2;
            this.volume = d3;
            this.panning = d4;
            this.loopType = n;
            this.loopStart = n2;
            this.loopLength = n3;
        }

        public void setMute(boolean bl) {
            this.mute = bl;
        }

        public boolean isMute() {
            return this.mute;
        }

        public void mix(int n, int n2) {
            int n3;
            int[] nArray;
            double d = this.volume;
            if (n2 == 1) {
                d = this.volume * (1.0 - this.panning);
            } else if (n2 == 2) {
                d = this.volume * this.panning;
            } else if (n2 == 3) {
                d = this.volume;
            }
            if (this.sampleData == null || this.mute || d == 0.0) {
                return;
            }
            double d2 = this.rate / 44100.0;
            if (n2 == 3 || n2 == 1) {
                nArray = DefaultMixer.this.mixerBufferLeft;
                this.offset = this.offsetLeft;
            } else {
                nArray = DefaultMixer.this.mixerBufferRight;
                this.offset = this.offsetRight;
            }
            this.tmpBufferStart = n3 = (int)this.offset;
            this.tmpBufferEnd = n3;
            int n4 = 0;
            while (n4 < n) {
                if (this.tmpBufferEnd - this.tmpBufferStart <= 16) {
                    this.tmpBufferStart = this.tmpBufferEnd;
                    this.tmpBufferEnd += this.TBL / 2;
                    this.getTrackData(this.tmpBuffer, this.tmpBufferStart, this.tmpBufferEnd, n3, d);
                    n3 += this.TBL / 2;
                }
                int[] nArray2 = new int[]{n4};
                double[] dArray = new double[]{this.offset};
                this.llm.mix(nArray, nArray2, n, this.tmpBuffer, dArray, this.tmpBufferEnd, this.TBL, d2);
                n4 = nArray2[0];
                this.offset = dArray[0];
                this.tmpBufferStart = (int)this.offset;
            }
            if (n2 == 3 || n2 == 1) {
                this.offsetLeft = this.offset;
            } else {
                this.offsetRight = this.offset;
            }
        }

        private int getTrackData(short[] sArray, int n, int n2, int n3, double d) {
            int n4 = 0;
            if (this.loopType == 0) {
                n4 = this.noLoop(sArray, n, n2, this.sampleData, n3, d);
            } else if (this.loopType == 1) {
                n4 = this.forwardLoop(sArray, n, n2, this.sampleData, n3, d, this.loopStart, this.loopLength);
            } else if (this.loopType == 2) {
                n4 = this.pingPongLoop(sArray, n, n2, this.sampleData, n3, d, this.loopStart, this.loopLength);
            }
            return n4;
        }

        public int noLoop(short[] sArray, int n, int n2, short[] sArray2, int n3, double d) {
            int n4;
            int n5 = sArray.length - 1;
            int n6 = sArray2.length;
            int n7 = (int)(d * 256.0);
            for (n4 = n; n3 < n6 && n4 < n2; ++n3, ++n4) {
                sArray[n4 & n5] = (short)(sArray2[n3] * n7 >>> 8);
            }
            while (n4 < n2) {
                sArray[n4 & n5] = 0;
                ++n4;
            }
            return n4;
        }

        public int forwardLoop(short[] sArray, int n, int n2, short[] sArray2, int n3, double d, int n4, int n5) {
            int n6 = sArray.length - 1;
            int n7 = n;
            int n8 = n4 + n5;
            if (n8 >= sArray2.length) {
                n8 = sArray2.length;
            }
            int n9 = (int)(d * 256.0);
            while (n3 < n4 && n7 < n2) {
                sArray[n7 & n6] = (short)(sArray2[n3] * n9 >>> 8);
                ++n3;
                ++n7;
            }
            while (n7 < n2) {
                if (n3 >= n8) {
                    n3 = (n3 - n4) % n5 + n4;
                }
                sArray[n7 & n6] = (short)(sArray2[n3] * n9 >>> 8);
                ++n3;
                ++n7;
            }
            return n7;
        }

        public int pingPongLoop(short[] sArray, int n, int n2, short[] sArray2, int n3, double d, int n4, int n5) {
            int n6 = sArray.length - 1;
            int n7 = n;
            int n8 = (int)(d * 256.0);
            int n9 = n4 + n5;
            if (n9 >= sArray2.length) {
                n9 = sArray2.length;
            }
            while (n3 < n9 && n7 < n2) {
                sArray[n7 & n6] = (short)(sArray2[n3] * n8 >>> 8);
                ++n3;
                ++n7;
            }
            n3 = (n3 - n4) % (n5 * 2) + n4;
            int n10 = n9 * 2;
            while (n7 < n2) {
                while (n3 < n9 && n7 < n2) {
                    sArray[n7 & n6] = (short)(sArray2[n3] * n8 >>> 8);
                    ++n3;
                    ++n7;
                }
                while (n10 - n3 > n4 && n7 < n2) {
                    sArray[n7 & n6] = (short)(sArray2[n10 - ++n3] * n8 >>> 8);
                    ++n7;
                }
                n3 = n4;
            }
            return n7;
        }
    }
}

