/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player;

import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.Mixer;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.modplay.player.TrackState;
import com.vwp.sound.mod.modplay.player.effect.GlobalEffects;

public class ModuleState {
    private Module module;
    private Mixer mixer;
    private GlobalEffects effects;
    private TrackState[] trackStates;
    private int bpm;
    private int position;
    private int division;
    private int tick;
    private int positionsInModule;
    private int divisionsInPattern;
    private int ticksInDivision;
    private int patternDelay;

    public ModuleState(Module module, Mixer mixer) {
        this.module = module;
        this.mixer = mixer;
        this.position = 0;
        this.division = 0;
        this.tick = 0;
        this.patternDelay = 0;
        this.effects = new GlobalEffects();
        this.bpm = module.getInitialBpm();
        this.ticksInDivision = module.getInitialSpeed();
        this.divisionsInPattern = module.getPatternAtPos(0).getDivisions();
        this.positionsInModule = module.getNumberOfPositions();
        this.trackStates = new TrackState[module.getPatternAtPos(0).getTrackCount()];
        for (int i = 0; i < this.trackStates.length; ++i) {
            this.trackStates[i] = new TrackState(this, module, mixer, i);
        }
        Instrument[] instrumentArray = module.getInstruments();
        for (int i = 0; i < instrumentArray.length; ++i) {
            if (instrumentArray[i] == null || instrumentArray[i].getNumberOfAutoEffects() <= 0) continue;
            for (int j = 0; j < instrumentArray[i].getNumberOfAutoEffects(); ++j) {
                instrumentArray[i].getAutoEffects()[j].setNumberOfTracks(this.trackStates.length);
            }
        }
    }

    public boolean play() throws PlayerException {
        int n;
        int n2;
        int n3;
        int n4;
        Track track;
        int n5;
        for (n5 = 0; n5 < this.trackStates.length; ++n5) {
            track = this.module.getPatternAtPos(this.position).getTrack(n5);
            for (n4 = 0; n4 < track.getNumberOfEffects(this.division); ++n4) {
                n3 = track.getEffect(this.division, n4);
                n2 = track.getEffectArg1(this.division, n4);
                n = track.getEffectArg2(this.division, n4);
                this.effects.preEffect(this, n5, this.position, this.division, this.tick, n3, n2, n);
            }
        }
        for (n5 = 0; n5 < this.trackStates.length; ++n5) {
            this.trackStates[n5].preEffect(this.position, this.division, this.tick);
        }
        for (n5 = 0; n5 < this.trackStates.length; ++n5) {
            this.trackStates[n5].loadTick(this.position, this.division, this.tick);
        }
        for (n5 = 0; n5 < this.trackStates.length; ++n5) {
            track = this.module.getPatternAtPos(this.position).getTrack(n5);
            for (n4 = 0; n4 < track.getNumberOfEffects(this.division); ++n4) {
                n3 = track.getEffect(this.division, n4);
                n2 = track.getEffectArg1(this.division, n4);
                n = track.getEffectArg2(this.division, n4);
                this.effects.doEffect(this, n5, this.position, this.division, this.tick, n3, n2, n);
            }
        }
        for (n5 = 0; n5 < this.trackStates.length; ++n5) {
            this.trackStates[n5].doEffects(this.position, this.division, this.tick);
        }
        double d = this.getTickLength(this.ticksInDivision, this.bpm);
        for (n4 = 0; n4 < this.trackStates.length; ++n4) {
            this.trackStates[n4].setupMixer(this.position, this.division, this.tick, d);
        }
        this.mixer.play(d);
        for (n4 = 0; n4 < this.trackStates.length; ++n4) {
            this.trackStates[n4].postEffects(this.position, this.division, this.tick);
        }
        for (n4 = 0; n4 < this.trackStates.length; ++n4) {
            Track track2 = this.module.getPatternAtPos(this.position).getTrack(n4);
            for (n2 = 0; n2 < track2.getNumberOfEffects(this.division); ++n2) {
                n = track2.getEffect(this.division, n2);
                int n6 = track2.getEffectArg1(this.division, n2);
                int n7 = track2.getEffectArg2(this.division, n2);
                this.effects.postEffect(this, n4, this.position, this.division, this.tick, n, n6, n7);
            }
        }
        if (this.tick == this.ticksInDivision - 1 && this.patternDelay > 0) {
            --this.patternDelay;
            return true;
        }
        return this.nextTick();
    }

    private double getTickLength(int n, int n2) {
        double d = 24.0 * (double)n2 / (double)n;
        double d2 = d / 60.0;
        double d3 = 1000.0 / (d2 * (double)n);
        return d3;
    }

    private boolean nextTick() {
        if (++this.tick % this.ticksInDivision == 0) {
            this.tick = 0;
            this.divisionsInPattern = this.module.getPatternAtPos(this.position).getDivisions();
            if (++this.division % this.divisionsInPattern == 0) {
                this.division = 0;
                if (++this.position % this.positionsInModule == 0) {
                    return false;
                }
            }
        }
        return true;
    }

    public Module getModule() {
        return this.module;
    }

    public Mixer getMixer() {
        return this.mixer;
    }

    public int getPosition() {
        return this.position;
    }

    public int getPatternsInModule() {
        return this.positionsInModule;
    }

    public int getDivisionsInPattern() {
        return this.divisionsInPattern;
    }

    public int getTicksInDivision() {
        return this.ticksInDivision;
    }

    public int getTick() {
        return this.tick;
    }

    public int getDivision() {
        return this.division;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public void setSpeed(int n) {
        this.ticksInDivision = n;
    }

    public void setBpm(int n) {
        this.bpm = n;
    }

    public void jump(int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.positionsInModule) {
            n = this.positionsInModule - 1;
        }
        this.position = n;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.divisionsInPattern) {
            n2 = this.divisionsInPattern - 1;
        }
        this.division = n2;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.ticksInDivision) {
            n3 = this.ticksInDivision - 1;
        }
        this.tick = n3;
    }

    public void setPatternDelay(int n) {
        this.patternDelay = n * this.ticksInDivision;
    }
}

