/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player;

import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.Mixer;
import com.vwp.sound.mod.modplay.player.ModuleState;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;
import com.vwp.sound.mod.modplay.player.autoeffect.Envelope;
import com.vwp.sound.mod.modplay.player.effect.LocalEffects;

public class TrackState {
    private ModuleState moduleState;
    private Module module;
    private Mixer mixer;
    private LocalEffects effects;
    private int trackNumber;
    private double volume;
    private double panning;
    private int note;
    private double relativeNote;
    private double fineTune;
    private int instrument;
    private double sampleOffset;
    private Sample sample;
    private int loopType;
    private int loopStart;
    private int loopLength;
    private int sampleDelay;
    private double envelopeVolume;
    private double fadeoutVolume;
    private double envelopePanning;
    private AutoEffect[] autoEffects;

    public TrackState(ModuleState moduleState, Module module, Mixer mixer, int n) {
        this.moduleState = moduleState;
        this.module = module;
        this.mixer = mixer;
        this.effects = new LocalEffects();
        this.trackNumber = n;
        this.panning = module.getInitialPanning(n);
        this.note = -2;
        this.instrument = -1;
        this.sampleDelay = 0;
        this.envelopeVolume = 1.0;
        this.fadeoutVolume = 1.0;
        this.envelopePanning = 0.5;
    }

    public void preEffect(int n, int n2, int n3) {
        Track track = this.module.getPatternAtPos(n).getTrack(this.trackNumber);
        for (int i = 0; i < track.getNumberOfEffects(n2); ++i) {
            int n4 = track.getEffect(n2, i);
            int n5 = track.getEffectArg1(n2, i);
            int n6 = track.getEffectArg2(n2, i);
            this.effects.preEffect(this, this.trackNumber, n, n2, n3, n4, n5, n6);
        }
    }

    public void loadTick(int n, int n2, int n3) {
        if (n3 == this.sampleDelay) {
            this.sampleDelay = 0;
            int n4 = this.getNote(n, n2, this.trackNumber);
            int n5 = this.getInstrument(n, n2, this.trackNumber);
            if (n4 != -2 && !this.noteIsArgument(n, n2, this.trackNumber) && n5 != -1) {
                this.newNoteAndInstrument(n4, n5);
            } else if (n4 != -2 && !this.noteIsArgument(n, n2, this.trackNumber) && n5 == -1) {
                this.newNote(n4);
            } else if ((n4 == -2 || this.noteIsArgument(n, n2, this.trackNumber)) && n5 != -1) {
                this.newInstrument(n5);
            }
        }
    }

    public void doEffects(int n, int n2, int n3) {
        int n4;
        Track track = this.module.getPatternAtPos(n).getTrack(this.trackNumber);
        for (n4 = 0; n4 < track.getNumberOfEffects(n2); ++n4) {
            int n5 = track.getEffect(n2, n4);
            int n6 = track.getEffectArg1(n2, n4);
            int n7 = track.getEffectArg2(n2, n4);
            this.effects.doEffect(this, this.trackNumber, n, n2, n3, n5, n6, n7);
        }
        this.envelopeVolume = 1.0;
        this.fadeoutVolume = 1.0;
        this.envelopePanning = 0.5;
        for (n4 = 0; this.autoEffects != null && n4 < this.autoEffects.length; ++n4) {
            this.autoEffects[n4].doEffect(this, this.trackNumber);
        }
    }

    public void setupMixer(int n, int n2, int n3, double d) throws PlayerException {
        double d2 = this.sample != null ? this.sample.getUnits().note2rate((double)this.note + this.fineTune + this.relativeNote + this.effects.noteTune + this.effects.noteSlide) : 0.0;
        double d3 = (this.volume + this.effects.volumeSlide + this.effects.tremoloValue) * this.envelopeVolume * this.fadeoutVolume;
        if (d3 < 0.0) {
            d3 = 0.0;
        } else if (d3 > 1.0) {
            d3 = 1.0;
        }
        double d4 = this.panning + this.effects.panningSlide;
        d4 += Math.min(d4, 1.0 - d4) * (this.envelopePanning - 0.5) * 2.0;
        if (d4 < 0.0) {
            d4 = 0.0;
        } else if (d4 > 1.0) {
            d4 = 1.0;
        }
        this.mixer.setTrack(this.sample != null ? this.sample.getData() : null, this.sampleOffset, d2, d3, d4, this.loopType, this.loopStart, this.loopLength, this.trackNumber);
        this.sampleOffset += d * d2 / 1000.0;
    }

    public void postEffects(int n, int n2, int n3) {
        Track track = this.module.getPatternAtPos(n).getTrack(this.trackNumber);
        for (int i = 0; i < track.getNumberOfEffects(n2); ++i) {
            int n4 = track.getEffect(n2, i);
            int n5 = track.getEffectArg1(n2, i);
            int n6 = track.getEffectArg2(n2, i);
            this.effects.postEffect(this, this.trackNumber, n, n2, n3, n4, n5, n6);
        }
    }

    public ModuleState getModuleState() {
        return this.moduleState;
    }

    public Module getModule() {
        return this.module;
    }

    public void setVolume(double d) {
        this.volume = d;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setPanning(double d) {
        this.panning = d;
    }

    public void setFineTune(double d) {
        this.fineTune = d;
    }

    public void setSampleOffset(double d) {
        this.sampleOffset = d;
    }

    public void setSampleDelay(int n) {
        this.sampleDelay = n;
    }

    public void setEnvelopePosition(int n) {
        for (int i = 0; this.autoEffects != null && i < this.autoEffects.length; ++i) {
            if (!(this.autoEffects[i] instanceof Envelope)) continue;
            ((Envelope)this.autoEffects[i]).setPosition(n, this.trackNumber);
        }
    }

    public int getNote() {
        return this.note;
    }

    public void setEnvelopePanning(double d) {
        this.envelopePanning = d;
    }

    public void setEnvelopeVolume(double d) {
        this.envelopeVolume = d;
    }

    public void setFadeoutVolume(double d) {
        this.fadeoutVolume = d;
    }

    private boolean noteIsArgument(int n, int n2, int n3) {
        Track track = this.module.getPatternAtPos(n).getTrack(n3);
        for (int i = 0; i < track.getNumberOfEffects(n2); ++i) {
            int n4 = track.getEffect(n2, i);
            if (n4 != 3 && n4 != 42) continue;
            return true;
        }
        return false;
    }

    private int getNote(int n, int n2, int n3) {
        Track track = this.module.getPatternAtPos(n).getTrack(n3);
        int n4 = track.getNote(n2);
        return n4;
    }

    private int getInstrument(int n, int n2, int n3) {
        Track track = this.module.getPatternAtPos(n).getTrack(n3);
        int n4 = track.getInstrumentNumber(n2);
        return n4;
    }

    private Sample getSample(int n, int n2) {
        Instrument instrument = this.module.getInstrument(n);
        Sample sample = null;
        if (instrument != null) {
            sample = instrument.getSampleByNote(n2);
        }
        return sample;
    }

    private void newNoteAndInstrument(int n, int n2) {
        this.effects.newNoteAndInstrument(n, n2);
        this.note = n;
        this.instrument = n2;
        Sample sample = this.getSample(this.instrument, this.note);
        if (sample != null) {
            this.fineTune = sample.getFineTune();
            this.relativeNote = sample.getRelativeNote();
            this.sample = sample;
            this.volume = sample.getVolume();
            if (this.module.getPanningType() == 2) {
                this.panning = sample.getPanning();
            } else if (this.module.getPanningType() == 1) {
                this.panning = this.module.getInitialPanning(this.trackNumber);
            } else if (this.module.getPanningType() == 3) {
                this.panning = this.module.getInstrument(this.instrument).getPanning();
            }
            this.loopType = sample.getLoopType();
            this.loopStart = sample.getLoopStart();
            this.loopLength = sample.getLoopLength();
        } else {
            this.fineTune = 0.0;
            this.relativeNote = 0.0;
            this.sample = null;
            this.volume = 1.0;
            this.panning = 0.5;
        }
        this.sampleOffset = 0.0;
        Instrument instrument = this.module.getInstrument(this.instrument);
        if (instrument != null) {
            this.autoEffects = instrument.getAutoEffects();
        }
        for (int i = 0; this.autoEffects != null && i < this.autoEffects.length; ++i) {
            this.autoEffects[i].reset(this.trackNumber);
            this.autoEffects[i].newNote(n, this.trackNumber);
        }
    }

    private void newNote(int n) {
        this.effects.newNote(n);
        for (int i = 0; this.autoEffects != null && i < this.autoEffects.length; ++i) {
            this.autoEffects[i].newNote(n, this.trackNumber);
        }
        this.note = n;
        Sample sample = this.getSample(this.instrument, this.note);
        if (sample != null) {
            this.fineTune = sample.getFineTune();
            this.relativeNote = sample.getRelativeNote();
            this.sample = sample;
            this.loopType = sample.getLoopType();
            this.loopStart = sample.getLoopStart();
            this.loopLength = sample.getLoopLength();
        } else {
            this.fineTune = 0.0;
            this.relativeNote = 0.0;
            sample = null;
        }
        this.sampleOffset = 0.0;
    }

    private void newInstrument(int n) {
        this.volume = 1.0;
        this.panning = 0.5;
    }

    public Sample getSample() {
        return this.sample;
    }

    public int getInstrument() {
        return this.instrument;
    }
}

