/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player.autoeffect;

import com.vwp.sound.mod.modplay.player.TrackState;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;

public class Fadeout
implements AutoEffect {
    private boolean on = true;
    private double fadeout;
    private boolean[] active;
    private int[] count;

    public Fadeout(double d) {
        this.fadeout = d;
    }

    @Override
    public void setNumberOfTracks(int n) {
        this.active = new boolean[n];
        this.count = new int[n];
    }

    @Override
    public void doEffect(TrackState trackState, int n) {
        if (this.on && this.active[n]) {
            double d = 1.0 - (double)this.count[n] * this.fadeout;
            if (d < 0.0) {
                trackState.setFadeoutVolume(0.0);
            } else {
                trackState.setFadeoutVolume(d);
            }
            int n2 = n;
            this.count[n2] = this.count[n2] + 1;
        } else if (!this.on && this.active[n]) {
            trackState.setFadeoutVolume(0.0);
        }
    }

    @Override
    public void keyOff(int n) {
        this.count[n] = 0;
        this.active[n] = true;
    }

    @Override
    public void newNote(double d, int n) {
        if (d != -2.0) {
            this.active[n] = false;
        }
    }

    @Override
    public void reset(int n) {
        this.active[n] = false;
        this.count[n] = 0;
    }

    public void activate() {
        this.on = true;
    }

    public void deActivate() {
        this.on = false;
    }
}

