/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player.autoeffect;

import com.vwp.sound.mod.modplay.player.TrackState;
import com.vwp.sound.mod.modplay.player.autoeffect.Envelope;

public class PanningEnvelope
implements Envelope {
    private int sustainPoint;
    private int loopStart;
    private int loopEnd;
    private int type;
    public static final int ON = 1;
    public static final int SUSTAIN = 2;
    public static final int LOOP = 4;
    private boolean on;
    private boolean[] keyOff;
    private double[] panningCurve;
    private int[] tOffset;

    public PanningEnvelope(int[] nArray, double[] dArray, int n, int n2, int n3, int n4, int n5) {
        if (n4 - n3 <= 0 && (n5 & 4) != 0) {
            n5 -= 4;
        }
        this.type = n5;
        this.on = true;
        if ((n5 & 1) == 0 || n == 0) {
            this.panningCurve = new double[]{0.5};
            this.on = false;
        } else if (n > 1) {
            this.panningCurve = new double[nArray[n - 1]];
            for (int i = 0; i < n - 1; ++i) {
                for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                    this.panningCurve[j] = dArray[i] + (dArray[i + 1] - dArray[i]) * (double)(j - nArray[i]) / (double)(nArray[i + 1] - nArray[i]);
                }
            }
        } else {
            this.panningCurve = new double[]{dArray[0]};
        }
        if ((n5 & 2) != 0) {
            this.sustainPoint = nArray[n2];
        }
        if ((n5 & 4) != 0) {
            this.loopStart = nArray[n3];
            if (this.loopStart < 0) {
                this.loopStart = 0;
            }
            this.loopEnd = nArray[n4];
            if (this.loopEnd > this.panningCurve.length) {
                this.loopEnd = this.panningCurve.length;
            }
        }
    }

    @Override
    public void setNumberOfTracks(int n) {
        this.tOffset = new int[n];
        this.keyOff = new boolean[n];
    }

    @Override
    public void keyOff(int n) {
        this.keyOff[n] = true;
    }

    @Override
    public void newNote(double d, int n) {
        if (d != -2.0) {
            this.tOffset[n] = 0;
            this.keyOff[n] = false;
        }
    }

    @Override
    public void doEffect(TrackState trackState, int n) {
        int n2 = this.tOffset[n];
        if (!this.on) {
            trackState.setEnvelopePanning(this.panningCurve[0]);
            return;
        }
        if ((this.type & 4) != 0) {
            if (n2 < this.loopEnd) {
                trackState.setEnvelopePanning(this.panningCurve[n2]);
            } else {
                int n3 = (n2 - this.loopStart) % (this.loopEnd - this.loopStart) + this.loopStart;
                trackState.setEnvelopePanning(this.panningCurve[n3]);
            }
        } else if (n2 >= this.panningCurve.length) {
            trackState.setEnvelopePanning(this.panningCurve[this.panningCurve.length - 1]);
        } else {
            trackState.setEnvelopePanning(this.panningCurve[n2]);
        }
        if ((this.type & 2) == 0 || n2 != this.sustainPoint || this.keyOff[n]) {
            int n4 = n;
            this.tOffset[n4] = this.tOffset[n4] + 1;
        }
    }

    @Override
    public void reset(int n) {
        this.keyOff[n] = false;
        this.tOffset[n] = 0;
    }

    @Override
    public void setPosition(int n, int n2) {
        this.tOffset[n2] = n < this.panningCurve.length ? n : this.panningCurve.length - 1;
    }
}

