/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player.autoeffect;

import com.vwp.sound.mod.modplay.player.TrackState;
import com.vwp.sound.mod.modplay.player.autoeffect.Envelope;

public class VolumeEnvelope
implements Envelope {
    private int sustainPoint;
    private int loopStart;
    private int loopEnd;
    private int type;
    public static final int ON = 1;
    public static final int SUSTAIN = 2;
    public static final int LOOP = 4;
    private boolean on;
    private boolean[] keyOff;
    private double[] volumeCurve;
    private int[] tOffset;

    public VolumeEnvelope(int[] nArray, double[] dArray, int n, int n2, int n3, int n4, int n5) {
        if (n4 - n3 <= 0 && (n5 & 4) != 0) {
            n5 -= 4;
        }
        this.type = n5;
        this.on = true;
        if ((n5 & 1) == 0 || n == 0) {
            this.volumeCurve = new double[]{1.0};
            this.on = false;
        } else if (n > 1) {
            this.volumeCurve = new double[nArray[n - 1]];
            for (int i = 0; i < n - 1; ++i) {
                for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                    this.volumeCurve[j] = dArray[i] + (dArray[i + 1] - dArray[i]) * (double)(j - nArray[i]) / (double)(nArray[i + 1] - nArray[i]);
                }
            }
        } else {
            this.volumeCurve = new double[]{dArray[0]};
        }
        if ((n5 & 2) != 0) {
            this.sustainPoint = nArray[n2];
        }
        if ((n5 & 4) != 0) {
            this.loopStart = nArray[n3];
            if (this.loopStart < 0) {
                this.loopStart = 0;
            }
            this.loopEnd = nArray[n4];
            if (this.loopEnd >= this.volumeCurve.length) {
                this.loopEnd = this.volumeCurve.length - 1;
            }
        }
    }

    @Override
    public void setNumberOfTracks(int n) {
        this.tOffset = new int[n];
        this.keyOff = new boolean[n];
    }

    @Override
    public void keyOff(int n) {
        this.keyOff[n] = true;
    }

    @Override
    public void newNote(double d, int n) {
        if (d != -2.0) {
            this.tOffset[n] = 0;
            this.keyOff[n] = false;
        }
    }

    @Override
    public void doEffect(TrackState trackState, int n) {
        int n2 = this.tOffset[n];
        if (!this.on) {
            trackState.setEnvelopeVolume(this.volumeCurve[0]);
            return;
        }
        if ((this.type & 4) != 0) {
            if (n2 < this.loopEnd) {
                trackState.setEnvelopeVolume(this.volumeCurve[n2]);
            } else {
                int n3 = (n2 - this.loopStart) % (this.loopEnd - this.loopStart) + this.loopStart;
                trackState.setEnvelopeVolume(this.volumeCurve[n3]);
            }
        } else if (n2 >= this.volumeCurve.length) {
            trackState.setEnvelopeVolume(this.volumeCurve[this.volumeCurve.length - 1]);
        } else {
            trackState.setEnvelopeVolume(this.volumeCurve[n2]);
        }
        if ((this.type & 2) == 0 || n2 != this.sustainPoint || this.keyOff[n]) {
            int n4 = n;
            this.tOffset[n4] = this.tOffset[n4] + 1;
        }
    }

    public boolean isActive() {
        return this.on;
    }

    @Override
    public void reset(int n) {
        this.keyOff[n] = false;
        this.tOffset[n] = 0;
    }

    @Override
    public void setPosition(int n, int n2) {
        this.tOffset[n2] = n < this.volumeCurve.length ? n : this.volumeCurve.length - 1;
    }
}

