/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player.effect;

import com.vwp.sound.mod.modplay.player.ModuleState;
import com.vwp.sound.mod.modplay.player.effect.Effect;

public class GlobalEffects
implements Effect {
    private int loopStart;
    private int patternToLoop;
    private int loopCount = -1;
    private double globalVolumeSlideSpeed;

    public void preEffect(ModuleState moduleState, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    public void doEffect(ModuleState moduleState, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (n5) {
            case 15: {
                this.modSetSpeed(moduleState, n4, n6, n7);
                break;
            }
            case 16: {
                System.err.println("Set filter not supported @ GlobalEffects.doEffect()");
                break;
            }
            case 22: {
                this.modLoopPatternStart(moduleState, n4, n6, n7);
                break;
            }
            case 30: {
                if (n4 != 0) break;
                moduleState.setPatternDelay(n7);
                break;
            }
            case 48: {
                if (n4 != 0) break;
                moduleState.getMixer().setVolume((double)(n6 * 16 + n7) / 64.0);
                break;
            }
            case 49: {
                this.xmGlobalVolumeSlide(moduleState, n4, n6, n7);
                break;
            }
        }
    }

    public void postEffect(ModuleState moduleState, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (n5) {
            case 11: {
                this.modPositionJump(moduleState, n4, n6, n7);
                break;
            }
            case 13: {
                this.modPatternBreak(moduleState, n4, n6, n7);
                break;
            }
            case 22: {
                this.modLoopPatternEnd(moduleState, n4, n6, n7);
            }
        }
    }

    private void modPositionJump(ModuleState moduleState, int n, int n2, int n3) {
        if (n == moduleState.getTicksInDivision() - 1) {
            if (n2 * 16 + n3 > 0) {
                moduleState.jump(n2 * 16 + n3 - 1, moduleState.getDivisionsInPattern() - 1, moduleState.getTicksInDivision() - 1);
            } else {
                moduleState.jump(0, 0, moduleState.getTicksInDivision() - 1);
            }
        }
    }

    private void modPatternBreak(ModuleState moduleState, int n, int n2, int n3) {
        if (n == moduleState.getTicksInDivision() - 1) {
            if (n2 * 10 + n3 == 0) {
                moduleState.jump(moduleState.getPosition(), moduleState.getDivisionsInPattern() - 1, moduleState.getTicksInDivision() - 1);
            } else {
                moduleState.jump(moduleState.getPosition() + 1, n2 * 10 + n3 - 1, moduleState.getTicksInDivision() - 1);
            }
        }
    }

    private void modLoopPatternStart(ModuleState moduleState, int n, int n2, int n3) {
        if (n == 0 && n3 == 0) {
            this.loopStart = moduleState.getDivision();
            this.patternToLoop = moduleState.getPosition();
        }
    }

    private void modLoopPatternEnd(ModuleState moduleState, int n, int n2, int n3) {
        if (n == moduleState.getTicksInDivision() - 1 && n3 != 0) {
            if (this.patternToLoop != moduleState.getPosition()) {
                this.patternToLoop = moduleState.getPosition();
                this.loopStart = 0;
            }
            if (this.loopCount == -1) {
                this.loopCount = n3 - 1;
                moduleState.jump(moduleState.getPosition(), this.loopStart - 1, moduleState.getTicksInDivision() - 1);
            } else if (this.loopCount > 0) {
                --this.loopCount;
                moduleState.jump(moduleState.getPosition(), this.loopStart - 1, moduleState.getTicksInDivision() - 1);
            } else {
                this.loopCount = -1;
            }
        }
    }

    private void xmGlobalVolumeSlide(ModuleState moduleState, int n, int n2, int n3) {
        if (n == 0) {
            if (n2 != 0) {
                this.globalVolumeSlideSpeed = (double)n2 / 64.0;
            } else if (n3 != 0) {
                this.globalVolumeSlideSpeed = (double)(-n3) / 64.0;
            }
        }
        if (n > 0) {
            double d = moduleState.getMixer().getVolume();
            moduleState.getMixer().setVolume(d += this.globalVolumeSlideSpeed);
        }
    }

    private void modSetSpeed(ModuleState moduleState, int n, int n2, int n3) {
        if (n == 0) {
            int n4 = n2 * 16 + n3;
            if (n4 == 0) {
                n4 = 1;
            }
            if (n4 <= 32) {
                moduleState.setSpeed(n4);
            } else {
                moduleState.setBpm(n4);
            }
        }
    }
}

