/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player.effect;

import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.ModuleUnits;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.player.TrackState;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;
import com.vwp.sound.mod.modplay.player.effect.Effect;

public class LocalEffects
implements Effect {
    public double tremoloValue;
    public double volumeSlide;
    private double volumeSlideSpeed;
    private double volumeFineSlideSpeed;
    private int tremoloWaveform = 0;
    private boolean tremoloRetrigger = true;
    public double panningSlide = 0.0;
    private double panningSlideSpeed;
    public double noteTune;
    public double noteSlide;
    private double noteSlideSmooth;
    private int noteSlideDest;
    private int noteSlideToSpeed;
    private double noteSlideSpeed;
    private double noteFineSlideSpeed;
    private double noteExtraFineSlideSpeed;
    private int vibratoWaveform = 0;
    private boolean vibratoRetrigger = true;
    private boolean glissando = false;
    private int retriggerInterval = 0;
    private int retriggerVolumeChange = 0;
    public static final int SINE_TREMOLO = 0;
    public static final int SAWTOOTH_TREMOLO = 1;
    public static final int SQUARE_TREMOLO = 2;
    private double tremoloPeriod;
    private double tremoloAmplitude;
    private int tremoloTick;
    public static final int SINE_VIBRATO = 0;
    public static final int SAWTOOTH_VIBRATO = 1;
    public static final int SQUARE_VIBRATO = 2;
    private double vibratoPeriod;
    private double vibratoAmplitude;
    private int vibratoTick;

    public LocalEffects() {
        this.reset();
    }

    public void preEffect(TrackState trackState, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (n5) {
            case 29: {
                this.modExtendedDelaySample(trackState, n, n4, n5, n6, n7);
            }
        }
    }

    public void doEffect(TrackState trackState, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.noteTune = 0.0;
        this.tremoloValue = 0.0;
        switch (n5) {
            case 0: {
                this.modArpeggio(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 1: {
                this.modSlideUp(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 2: {
                this.modSlideDown(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 3: {
                this.modSlideToNote(trackState, n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 4: {
                this.modVibrato(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 5: {
                this.modSlideToNote(trackState, n, n2, n3, n4, n5, 0, 0);
                this.modVolumeSlide(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 6: {
                this.modVibrato(trackState, n, n4, n5, 0, 0);
                this.modVolumeSlide(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 7: {
                this.modTremolo(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 8: {
                this.modPanning(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 9: {
                this.modSetSampleOffset(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 10: {
                this.modVolumeSlide(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 12: {
                this.modSetVolume(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 17: {
                this.modExtendedFineSlideUp(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 18: {
                this.modExtendedFineSlideDown(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 19: {
                if (n7 == 1) {
                    this.glissando = true;
                    break;
                }
                if (n7 != 0) break;
                this.glissando = false;
                break;
            }
            case 20: {
                this.modExtendedSetVibratoWaveform(n7);
                break;
            }
            case 21: {
                this.modExtendedFineTune(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 23: {
                this.modExtendedSetTremoloWaveform(n7);
                break;
            }
            case 24: {
                this.modExtendedRoughPanning(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 25: {
                this.modExtendedRetriggerSample(trackState, n, n4, n5, n6, n7, n2);
                break;
            }
            case 26: {
                this.modExtendedFineVolumeSlideUp(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 27: {
                this.modExtendedFineVolumeSlideDown(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 28: {
                this.modExtendedCutSample(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 31: {
                System.err.println("Invert loop not supported @ LocalEffect.doEffect()");
                break;
            }
            case 40: {
                this.xmSlideUp(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 41: {
                this.xmSlideDown(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 42: {
                this.xmSlideToNote(trackState, n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 43: {
                this.xmVolumeSlide(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 44: {
                this.xmExtendedFineSlideUp(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 45: {
                this.xmExtendedFineSlideDown(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 46: {
                this.xmExtendedFineVolumeSlideUp(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 47: {
                this.xmExtendedFineVolumeSlideDown(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 51: {
                if (n4 != 0) break;
                trackState.setEnvelopePosition(n6 * 16 + n7);
                break;
            }
            case 52: {
                this.xmPanningSlide(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 53: {
                this.xmMultiRetriggerNote(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 55: {
                this.xmExtraFineSlideUp(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 56: {
                this.xmExtraFineSlideDown(trackState, n, n4, n5, n6, n7);
                break;
            }
            case 50: {
                this.keyOff(trackState, n, n4);
                break;
            }
            case 60: {
                this.s3mTremor(trackState, n, n4, n5, n6, n7);
            }
        }
    }

    public void postEffect(TrackState trackState, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (n5) {
            case 60: {
                this.s3mTremorStop(trackState, n, n4, n5, n6, n7);
            }
        }
    }

    public void newNote(int n) {
        this.reset();
    }

    public void newInstrument(int n) {
    }

    public void newNoteAndInstrument(int n, int n2) {
        this.reset();
    }

    public void reset() {
        if (this.vibratoRetrigger) {
            this.vibratoTick = 0;
        }
        if (this.tremoloRetrigger) {
            this.tremoloTick = 0;
        }
        this.noteTune = 0.0;
        this.noteSlide = 0.0;
        this.noteSlideSmooth = 0.0;
        this.volumeSlide = 0.0;
        this.tremoloValue = 0.0;
        this.panningSlide = 0.0;
    }

    private void modArpeggio(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n4 == 0 && n5 == 0) {
            return;
        }
        if ((n2 %= 3) != 0) {
            if (n2 == 1) {
                this.noteTune += (double)n4;
            } else if (n2 == 2) {
                this.noteTune += (double)n5;
            }
        }
    }

    private void modSlideUp(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n2 > 0) {
            double d;
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getUpperNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = (double)trackState.getNote() + this.noteSlideSmooth;
            if (d4 == -2.0) {
                return;
            }
            double d5 = moduleUnits.note2period(d4) - (double)(n4 * 16 + n5);
            if (d5 < d3) {
                d5 = d3;
            }
            if ((d = moduleUnits.period2note(d5)) > d2) {
                d = d2;
            }
            this.noteSlide = this.noteSlideSmooth += d - d4;
        }
    }

    private void modSlideDown(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n2 > 0) {
            double d;
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getLowerNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = (double)trackState.getNote() + this.noteSlideSmooth;
            if (d4 == -2.0) {
                return;
            }
            double d5 = moduleUnits.note2period(d4) + (double)(n4 * 16 + n5);
            if (d5 > d3) {
                d5 = d3;
            }
            if ((d = moduleUnits.period2note(d5)) < d2) {
                d = d2;
            }
            this.noteSlide = this.noteSlideSmooth += d - d4;
        }
    }

    private void modSlideToNote(TrackState trackState, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n4 == 0) {
            int n8 = trackState.getModule().getPatternAtPos(n2).getTrack(n).getNote(n3);
            if (n8 != -2) {
                this.noteSlideDest = n8;
            }
            if (n6 * 16 + n7 != 0) {
                this.noteSlideToSpeed = n6 * 16 + n7;
            }
        } else {
            double d;
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getUpperNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = moduleUnits.getLowerNoteLimit();
            double d5 = moduleUnits.note2period(d4);
            double d6 = d = (double)trackState.getNote() + this.noteSlideSmooth;
            if ((double)this.noteSlideDest > d) {
                double d7 = moduleUnits.note2period(d) - (double)this.noteSlideToSpeed;
                if (d7 < d3) {
                    d7 = d3;
                }
                if ((d6 = moduleUnits.period2note(d7)) > (double)this.noteSlideDest) {
                    d6 = this.noteSlideDest;
                }
            } else if ((double)this.noteSlideDest < d) {
                double d8 = moduleUnits.note2period(d) + (double)this.noteSlideToSpeed;
                if (d8 > d5) {
                    d8 = d5;
                }
                if ((double)this.noteSlideDest > (d6 = moduleUnits.period2note(d8))) {
                    d6 = this.noteSlideDest;
                }
            }
            this.noteSlideSmooth += d6 - d;
            this.noteSlide = this.glissando ? (double)Math.round(this.noteSlideSmooth) : this.noteSlideSmooth;
        }
    }

    private void modVibrato(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        double d;
        if (n2 == 0) {
            if (n4 != 0) {
                this.vibratoPeriod = n4;
            }
            if (n5 != 0) {
                this.vibratoAmplitude = n5;
            }
        }
        this.noteTune = d = this.getVibratoLevel(this.vibratoPeriod, this.vibratoAmplitude, this.vibratoTick, this.vibratoWaveform);
        ++this.vibratoTick;
    }

    private double getVibratoLevel(double d, double d2, int n, int n2) {
        double d3 = 0.0;
        switch (n2) {
            case 0: {
                d3 = Math.sin((double)(n * 2) * 3.1416 * d / 64.0);
                break;
            }
            case 2: {
                d3 = (int)((double)(16 * n) * d / 64.0) % 16 < 8 ? 1.0 : -1.0;
                break;
            }
            case 1: {
                double d4;
                int n3 = (int)((double)(16 * n) * d / 64.0) % 16;
                d3 = d4 = 1.0 - (double)n3 / 8.0;
            }
        }
        return d3 *= d2 / 16.0;
    }

    public void modTremolo(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            if (n4 != 0) {
                this.tremoloPeriod = n4;
            }
            if (n5 != 0) {
                this.tremoloAmplitude = n5;
            }
        }
        double d = this.getTremoloLevel(this.tremoloPeriod, this.tremoloTick, this.tremoloWaveform);
        this.tremoloValue = d * this.tremoloAmplitude * (double)(trackState.getModuleState().getTicksInDivision() - 1) / 64.0;
        ++this.tremoloTick;
    }

    private double getTremoloLevel(double d, int n, int n2) {
        double d2 = 0.0;
        switch (n2) {
            case 0: {
                d2 = Math.sin((double)(n * 2) * 3.1416 * d / 64.0);
                break;
            }
            case 2: {
                d2 = (int)((double)(16 * n) * d / 64.0) % 16 < 8 ? 1.0 : -1.0;
                break;
            }
            case 1: {
                double d3;
                int n3 = (int)((double)(16 * n) * d / 64.0) % 16;
                d2 = d3 = 1.0 - (double)n3 / 8.0;
            }
        }
        return d2;
    }

    private void modPanning(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            trackState.setPanning((double)(n4 * 16 + n5) / 256.0);
        }
    }

    private void modSetSampleOffset(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            trackState.setSampleOffset(n4 * 4096 + n5 * 256);
        }
    }

    private void modVolumeSlide(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 > 0) {
            if (n4 != 0) {
                this.volumeSlide += (double)n4 / 64.0;
            } else if (n5 != 0) {
                this.volumeSlide -= (double)n5 / 64.0;
            }
        }
    }

    private void modSetVolume(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            trackState.setVolume((double)(n4 * 16 + n5) / 64.0);
        }
    }

    private void modExtendedFineSlideUp(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n2 == 0) {
            double d;
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getUpperNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = (double)trackState.getNote() + this.noteSlideSmooth;
            if (d4 == -2.0) {
                return;
            }
            double d5 = moduleUnits.note2period(d4) - (double)n5;
            if (d5 < d3) {
                d5 = d3;
            }
            if ((d = moduleUnits.period2note(d5)) > d2) {
                d = d2;
            }
            this.noteSlide = this.noteSlideSmooth += d - d4;
        }
    }

    private void modExtendedFineSlideDown(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n2 == 0) {
            double d;
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getLowerNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = (double)trackState.getNote() + this.noteSlideSmooth;
            if (d4 == -2.0) {
                return;
            }
            double d5 = moduleUnits.note2period(d4) + (double)n5;
            if (d5 > d3) {
                d5 = d3;
            }
            if ((d = moduleUnits.period2note(d5)) < d2) {
                d = d2;
            }
            this.noteSlide = this.noteSlideSmooth += d - d4;
        }
    }

    private void modExtendedFineTune(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            if ((n5 & 8) != 0) {
                n5 |= 0xFFFFFFF0;
            }
            trackState.setFineTune((double)n5 / 16.0);
        }
    }

    private void modExtendedSetTremoloWaveform(int n) {
        if (n > 3) {
            this.tremoloRetrigger = true;
            n -= 4;
        } else {
            this.tremoloRetrigger = false;
        }
        if (n == 3) {
            n = (int)(Math.random() * 3.0);
        }
        this.tremoloWaveform = n;
    }

    private void modExtendedSetVibratoWaveform(int n) {
        if (n > 3) {
            this.vibratoRetrigger = true;
            n -= 4;
        } else {
            this.vibratoRetrigger = false;
        }
        if (n == 3) {
            n = (int)(Math.random() * 3.0);
        }
        this.vibratoWaveform = n;
    }

    private void modExtendedRoughPanning(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        trackState.setPanning((double)n5 / 16.0);
    }

    private void modExtendedRetriggerSample(TrackState trackState, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == 0 && n2 == 0 || n5 != 0 && n2 % n5 == 0) {
            trackState.setSampleOffset(0.0);
        }
    }

    private void modExtendedFineVolumeSlideUp(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            this.volumeSlide += (double)n5 / 64.0;
        }
    }

    private void modExtendedFineVolumeSlideDown(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            this.volumeSlide -= (double)n5 / 64.0;
        }
    }

    private void modExtendedCutSample(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 >= n5) {
            trackState.setVolume(0.0);
        }
    }

    private void modExtendedDelaySample(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            trackState.setSampleDelay(n5);
        }
    }

    private void xmSlideUp(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n2 == 0 && (n4 != 0 || n5 != 0)) {
            this.noteSlideSpeed = (n4 * 16 + n5) * 4;
        }
        if (n2 > 0) {
            double d;
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getUpperNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = (double)trackState.getNote() + this.noteSlideSmooth;
            if (d4 == -2.0) {
                return;
            }
            double d5 = moduleUnits.note2period(d4) - this.noteSlideSpeed;
            if (d5 < d3) {
                d5 = d3;
            }
            if ((d = moduleUnits.period2note(d5)) > d2) {
                d = d2;
            }
            this.noteSlide = this.noteSlideSmooth += d - d4;
        }
    }

    private void xmSlideDown(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n2 == 0 && (n4 != 0 || n5 != 0)) {
            this.noteSlideSpeed = (n4 * 16 + n5) * 4;
        }
        if (n2 > 0) {
            double d;
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getLowerNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = (double)trackState.getNote() + this.noteSlideSmooth;
            if (d4 == -2.0) {
                return;
            }
            double d5 = moduleUnits.note2period(d4) + this.noteSlideSpeed;
            if (d5 > d3) {
                d5 = d3;
            }
            if ((d = moduleUnits.period2note(d5)) < d2) {
                d = d2;
            }
            this.noteSlide = this.noteSlideSmooth += d - d4;
        }
    }

    private void xmSlideToNote(TrackState trackState, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n4 == 0) {
            int n8 = trackState.getModule().getPatternAtPos(n2).getTrack(n).getNote(n3);
            if (n8 != -2) {
                this.noteSlideDest = n8;
            }
            if (n6 * 16 + n7 != 0) {
                this.noteSlideToSpeed = n6 * 16 + n7;
            }
        } else {
            double d;
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getUpperNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = moduleUnits.getLowerNoteLimit();
            double d5 = moduleUnits.note2period(d4);
            double d6 = d = (double)trackState.getNote() + this.noteSlideSmooth;
            if ((double)this.noteSlideDest > d) {
                double d7 = moduleUnits.note2period(d) - (double)(this.noteSlideToSpeed * 4);
                if (d7 < d3) {
                    d7 = d3;
                }
                if ((d6 = moduleUnits.period2note(d7)) > (double)this.noteSlideDest) {
                    d6 = this.noteSlideDest;
                }
            } else if ((double)this.noteSlideDest < d) {
                double d8 = moduleUnits.note2period(d) + (double)(this.noteSlideToSpeed * 4);
                if (d8 > d5) {
                    d8 = d5;
                }
                if ((double)this.noteSlideDest > (d6 = moduleUnits.period2note(d8))) {
                    d6 = this.noteSlideDest;
                }
            }
            this.noteSlideSmooth += d6 - d;
            this.noteSlide = this.glissando ? (double)Math.round(this.noteSlideSmooth) : this.noteSlideSmooth;
        }
    }

    private void xmVolumeSlide(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            if (n4 != 0) {
                this.volumeSlideSpeed = (double)n4 / 64.0;
            } else if (n5 != 0) {
                this.volumeSlideSpeed = (double)(-n5) / 64.0;
            }
        }
        if (n2 > 0) {
            this.volumeSlide += this.volumeSlideSpeed;
        }
    }

    private void xmExtendedFineSlideUp(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n2 == 0) {
            double d;
            if (n5 != 0) {
                this.noteFineSlideSpeed = n5 * 4;
            }
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getUpperNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = (double)trackState.getNote() + this.noteSlideSmooth;
            if (d4 == -2.0) {
                return;
            }
            double d5 = moduleUnits.note2period(d4) - this.noteFineSlideSpeed;
            if (d5 < d3) {
                d5 = d3;
            }
            if ((d = moduleUnits.period2note(d5)) > d2) {
                d = d2;
            }
            this.noteSlide = this.noteSlideSmooth += d - d4;
        }
    }

    private void xmExtendedFineSlideDown(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n2 == 0) {
            double d;
            if (n5 != 0) {
                this.noteFineSlideSpeed = n5 * 4;
            }
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getLowerNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = (double)trackState.getNote() + this.noteSlideSmooth;
            if (d4 == -2.0) {
                return;
            }
            double d5 = moduleUnits.note2period(d4) + this.noteFineSlideSpeed;
            if (d5 > d3) {
                d5 = d3;
            }
            if ((d = moduleUnits.period2note(d5)) < d2) {
                d = d2;
            }
            this.noteSlide = this.noteSlideSmooth += d - d4;
        }
    }

    private void xmExtendedFineVolumeSlideUp(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            if (n5 != 0) {
                this.volumeFineSlideSpeed = (double)n5 / 64.0;
            }
            this.volumeSlide += this.volumeFineSlideSpeed;
        }
    }

    private void xmExtendedFineVolumeSlideDown(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            if (n5 != 0) {
                this.volumeFineSlideSpeed = (double)n5 / 64.0;
            }
            this.volumeSlide -= this.volumeFineSlideSpeed;
        }
    }

    private void xmPanningSlide(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            if (n4 != 0) {
                this.panningSlideSpeed = (double)n4 / 256.0;
            } else if (n5 != 0) {
                this.panningSlideSpeed = (double)(-n5) / 256.0;
            }
        }
        if (n2 > 0) {
            this.panningSlide += this.panningSlideSpeed;
        }
    }

    private void xmMultiRetriggerNote(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == 0) {
            if (n4 != 0) {
                this.retriggerVolumeChange = n4;
            }
            if (n5 != 0) {
                this.retriggerInterval = n5;
            }
        }
        if (this.retriggerInterval != 0 && n2 % this.retriggerInterval == 0 && n2 != 0) {
            trackState.setSampleOffset(0.0);
            switch (this.retriggerVolumeChange) {
                case 0: {
                    break;
                }
                case 1: {
                    trackState.setVolume(trackState.getVolume() - 0.015625);
                    break;
                }
                case 2: {
                    trackState.setVolume(trackState.getVolume() - 0.03125);
                    break;
                }
                case 3: {
                    trackState.setVolume(trackState.getVolume() - 0.0625);
                    break;
                }
                case 4: {
                    trackState.setVolume(trackState.getVolume() - 0.125);
                    break;
                }
                case 5: {
                    trackState.setVolume(trackState.getVolume() - 0.25);
                    break;
                }
                case 6: {
                    trackState.setVolume(trackState.getVolume() * 2.0 / 3.0);
                    break;
                }
                case 7: {
                    trackState.setVolume(trackState.getVolume() * 2.0);
                    break;
                }
                case 9: {
                    trackState.setVolume(trackState.getVolume() + 0.015625);
                    break;
                }
                case 10: {
                    trackState.setVolume(trackState.getVolume() + 0.03125);
                    break;
                }
                case 11: {
                    trackState.setVolume(trackState.getVolume() + 0.0625);
                    break;
                }
                case 12: {
                    trackState.setVolume(trackState.getVolume() + 0.125);
                    break;
                }
                case 13: {
                    trackState.setVolume(trackState.getVolume() + 0.25);
                    break;
                }
                case 14: {
                    trackState.setVolume(trackState.getVolume() * 3.0 / 2.0);
                    break;
                }
                case 15: {
                    trackState.setVolume(trackState.getVolume() * 2.0);
                }
            }
        }
    }

    private void xmExtraFineSlideUp(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n2 == 0) {
            double d;
            if (n5 != 0) {
                this.noteExtraFineSlideSpeed = n5;
            }
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getUpperNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = (double)trackState.getNote() + this.noteSlideSmooth;
            if (d4 == -2.0) {
                return;
            }
            double d5 = moduleUnits.note2period(d4) - this.noteExtraFineSlideSpeed;
            if (d5 < d3) {
                d5 = d3;
            }
            if ((d = moduleUnits.period2note(d5)) > d2) {
                d = d2;
            }
            this.noteSlide = this.noteSlideSmooth += d - d4;
        }
    }

    private void xmExtraFineSlideDown(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        Sample sample = trackState.getSample();
        if (sample == null) {
            return;
        }
        if (n2 == 0) {
            double d;
            if (n5 != 0) {
                this.noteExtraFineSlideSpeed = n5;
            }
            ModuleUnits moduleUnits = sample.getUnits();
            double d2 = moduleUnits.getLowerNoteLimit();
            double d3 = moduleUnits.note2period(d2);
            double d4 = (double)trackState.getNote() + this.noteSlideSmooth;
            if (d4 == -2.0) {
                return;
            }
            double d5 = moduleUnits.note2period(d4) + this.noteExtraFineSlideSpeed;
            if (d5 > d3) {
                d5 = d3;
            }
            if ((d = moduleUnits.period2note(d5)) < d2) {
                d = d2;
            }
            this.noteSlide = this.noteSlideSmooth += d - d4;
        }
    }

    private void s3mTremor(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 < n4 * 16 + n5) {
            this.volumeSlide -= 5.0;
        }
    }

    private void s3mTremorStop(TrackState trackState, int n, int n2, int n3, int n4, int n5) {
        if (n2 == n4 * 16 + n5 || n4 * 16 + n5 >= trackState.getModuleState().getTicksInDivision()) {
            this.volumeSlide += 5.0;
        }
    }

    public void keyOff(TrackState trackState, int n, int n2) {
        if (n2 != 0) {
            return;
        }
        int n3 = trackState.getInstrument();
        if (n3 == -1) {
            return;
        }
        Instrument instrument = trackState.getModule().getInstrument(n3);
        AutoEffect[] autoEffectArray = instrument.getAutoEffects();
        for (int i = 0; autoEffectArray != null && i < autoEffectArray.length; ++i) {
            autoEffectArray[i].keyOff(n);
        }
    }
}

