/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.sound.output;

import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.sound.output.Output;
import com.vwp.sound.mod.sound.output.SoundDataFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class JavaSoundOutput
implements Output {
    private int[] supportedRates = new int[]{11025, 22050, 44100};
    private int[] supportedBits = new int[]{8, 16};
    private int[] supportedChannels = new int[]{1, 2};
    private SoundDataFormat format;
    private SourceDataLine sdl;
    private AudioFormat af;
    private boolean opened = false;
    private int bufferTime;
    private boolean signed = true;
    private boolean bigendian = false;
    private long deliveredData = 0L;
    byte[] mixbuffer = new byte[1000];

    public JavaSoundOutput(SoundDataFormat soundDataFormat, int n) throws PlayerException {
        this.bufferTime = n;
        this.format = soundDataFormat;
        this.init();
    }

    public boolean supports(SoundDataFormat soundDataFormat) {
        int n;
        int n2;
        boolean bl = false;
        int n3 = soundDataFormat.getRate();
        for (n2 = 0; n2 < this.supportedRates.length; ++n2) {
            if (this.supportedRates[n2] != n3) continue;
            bl = true;
        }
        n2 = 0;
        int n4 = soundDataFormat.getBits();
        for (n = 0; n < this.supportedBits.length; ++n) {
            if (this.supportedBits[n] != n4) continue;
            n2 = 1;
        }
        n = 0;
        int n5 = soundDataFormat.getChannels();
        for (int i = 0; i < this.supportedChannels.length; ++i) {
            if (this.supportedChannels[i] != n5) continue;
            n = 1;
        }
        return bl && n2 != 0 && n != 0;
    }

    public SoundDataFormat getFormat() {
        return this.format;
    }

    private void init() throws PlayerException {
        Line line;
        if (!this.supports(this.format)) {
            throw new PlayerException("data format not supported: " + this.format);
        }
        this.af = new AudioFormat(this.format.getRate(), this.format.getBits(), this.format.getChannels(), this.signed, this.bigendian);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.af);
        if (AudioSystem.isLineSupported(info)) {
            line = null;
            try {
                line = AudioSystem.getLine(info);
            }
            catch (LineUnavailableException lineUnavailableException) {
                throw new PlayerException("Can't get line");
            }
            if (!(line instanceof SourceDataLine)) {
                throw new PlayerException("line not a SourceDataLine!");
            }
        } else {
            throw new PlayerException("Line not supported");
        }
        this.sdl = (SourceDataLine)line;
        if (this.sdl == null) {
            throw new PlayerException("line not found");
        }
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public boolean open() {
        boolean bl = true;
        this.opened = true;
        try {
            this.sdl.open(this.af);
            this.sdl.start();
        }
        catch (Exception exception) {
            bl = false;
            this.opened = false;
        }
        return bl;
    }

    @Override
    public boolean close() {
        boolean bl = true;
        try {
            this.sdl.stop();
            this.sdl.close();
        }
        catch (Exception exception) {
            System.err.println("Could not close or stop SoundDataLine: " + this.sdl);
            bl = false;
        }
        this.opened = false;
        return bl;
    }

    @Override
    public int write(byte[] byArray, int n, int n2) {
        int n3 = 10;
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        while (n5 < n + n2 && n3 > 0) {
            int n7 = 0;
            n7 = this.format.getBits() == 16 && this.format.getChannels() == 2 && this.format.getRate() == 44100 ? this.sdl.write(byArray, n5, n6) : this.writeConv(byArray, n5, n6);
            n5 += n7;
            n6 -= n7;
            n4 += n7;
            --n3;
            this.deliveredData += (long)n7;
            int n8 = (int)(1000L * this.deliveredData / 176400L);
            long l = this.sdl.getMicrosecondPosition() / 1000L;
            long l2 = (long)n8 - l - (long)this.bufferTime;
            if (l2 < 0L) {
                l2 = 0L;
            }
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
        }
        return n4;
    }

    protected int writeConv(byte[] byArray, int n, int n2) {
        double d = 44100.0 / (double)this.format.getRate();
        int n3 = 0;
        if (this.format.getBits() == 8 && this.format.getChannels() == 1) {
            n3 = this.mono8(byArray, n, n2, d);
        } else if (this.format.getBits() == 8 && this.format.getChannels() == 2) {
            n3 = this.stereo8(byArray, n, n2, d);
        } else if (this.format.getBits() == 16 && this.format.getChannels() == 1) {
            n3 = this.mono16(byArray, n, n2, d);
        } else if (this.format.getBits() == 16 && this.format.getChannels() == 2) {
            n3 = this.stereo16(byArray, n, n2, d);
        }
        return n3;
    }

    protected int mono8(byte[] byArray, int n, int n2, double d) {
        int n3 = n;
        double d2 = 0.0;
        while (n3 < n2 + n) {
            int n4;
            for (n4 = 0; n3 < n2 + n && n4 < this.mixbuffer.length; ++n4) {
                this.mixbuffer[n4] = (byte)(byArray[n3 + 1] + byArray[n3 + 3] >> 1);
                n3 = n + (int)(d2 += d) * 4;
            }
            this.writeData(this.mixbuffer, 0, n4);
        }
        return n3 - n;
    }

    protected int stereo8(byte[] byArray, int n, int n2, double d) {
        int n3 = n;
        double d2 = 0.0;
        while (n3 < n2 + n) {
            int n4;
            for (n4 = 0; n3 < n2 + n && n4 < this.mixbuffer.length; n4 += 2) {
                this.mixbuffer[n4 + 0] = byArray[n3 + 1];
                this.mixbuffer[n4 + 1] = byArray[n3 + 3];
                n3 = n + (int)(d2 += d) * 4;
            }
            this.writeData(this.mixbuffer, 0, n4);
        }
        return n3 - n;
    }

    protected int mono16(byte[] byArray, int n, int n2, double d) {
        int n3 = 0;
        double d2 = 0.0;
        while (n3 < n2 + n) {
            int n4;
            for (n4 = 0; n3 < n2 + n && n4 < this.mixbuffer.length; n4 += 2) {
                this.mixbuffer[n4 + 0] = (byte)(byArray[n3 + 0] + byArray[n3 + 2] >> 1);
                this.mixbuffer[n4 + 1] = (byte)(byArray[n3 + 1] + byArray[n3 + 3] >> 1);
                n3 = n + (int)(d2 += d) * 4;
            }
            this.writeData(this.mixbuffer, 0, n4);
        }
        return n3 - n;
    }

    protected int stereo16(byte[] byArray, int n, int n2, double d) {
        int n3 = 0;
        double d2 = 0.0;
        while (n3 < n2 + n) {
            int n4;
            for (n4 = 0; n3 < n2 + n && n4 < this.mixbuffer.length; n4 += 4) {
                this.mixbuffer[n4 + 0] = byArray[n3 + 0];
                this.mixbuffer[n4 + 1] = byArray[n3 + 1];
                this.mixbuffer[n4 + 2] = byArray[n3 + 2];
                this.mixbuffer[n4 + 3] = byArray[n3 + 3];
                n3 = n + (int)(d2 += d) * 4;
            }
            this.writeData(this.mixbuffer, 0, n4);
        }
        return n3 - n;
    }

    private void writeData(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n4 += this.sdl.write(byArray, n + n4, n2 - n4);
            if (++n3 < 100) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n3 = 0;
        }
    }
}

