/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.sound.output;

import com.vwp.sound.mod.sound.output.Output;
import com.vwp.sound.mod.sound.output.SoundDataFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WavOutput
implements Output {
    private int[] supportedRates = new int[]{44100};
    private int[] supportedBits = new int[]{16};
    private int[] supportedChannels = new int[]{2};
    public static final String RIFF_MAGIC = "RIFF";
    private int length = 0;
    public static final String WAVE_MAGIC = "WAVE";
    public static final String FORMAT_MAGIC = "fmt ";
    public static final int FORMAT_LENGTH = 16;
    public static final short MORE_MAGIC = 1;
    private short channels = (short)2;
    private int rate = 44100;
    private short bytes_per_sample = (short)4;
    private int bytes_per_sec = this.rate * this.bytes_per_sample;
    private short bits_per_sample = (short)(this.bytes_per_sample / 2 * 8);
    public static final String DATA_MAGIC = "data";
    private int data_length = 0;
    private RandomAccessFile out;
    private String filename;

    public WavOutput(String string, SoundDataFormat soundDataFormat) throws IOException {
        if (!this.supports(soundDataFormat)) {
            throw new IOException("Format now supported: " + soundDataFormat.toString());
        }
        this.filename = string;
    }

    public boolean supports(SoundDataFormat soundDataFormat) {
        int n;
        int n2;
        boolean bl = false;
        int n3 = soundDataFormat.getRate();
        for (n2 = 0; n2 < this.supportedRates.length; ++n2) {
            if (this.supportedRates[n2] != n3) continue;
            bl = true;
        }
        n2 = 0;
        int n4 = soundDataFormat.getBits();
        for (n = 0; n < this.supportedBits.length; ++n) {
            if (this.supportedBits[n] != n4) continue;
            n2 = 1;
        }
        n = 0;
        int n5 = soundDataFormat.getChannels();
        for (int i = 0; i < this.supportedChannels.length; ++i) {
            if (this.supportedChannels[i] != n5) continue;
            n = 1;
        }
        return bl && n2 != 0 && n != 0;
    }

    @Override
    public boolean isOpen() {
        return this.out != null;
    }

    @Override
    public boolean open() {
        boolean bl = true;
        try {
            this.out = new RandomAccessFile(this.filename, "rw");
            this.out.seek(0L);
            this.out.write(RIFF_MAGIC.getBytes());
            this.writeInt(this.length);
            this.out.write(WAVE_MAGIC.getBytes());
            this.out.write(FORMAT_MAGIC.getBytes());
            this.writeInt(16);
            this.writeShort((short)1);
            this.writeShort(this.channels);
            this.writeInt(this.rate);
            this.writeInt(this.bytes_per_sec);
            this.writeShort(this.bytes_per_sample);
            this.writeShort(this.bits_per_sample);
            this.out.write(DATA_MAGIC.getBytes());
            this.writeInt(this.data_length);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private void writeInt(int n) throws IOException {
        this.out.write((n & 0xFF) >>> 0);
        this.out.write((n & 0xFF00) >>> 8);
        this.out.write((n & 0xFF0000) >>> 16);
        this.out.write((n & 0xFF000000) >>> 24);
    }

    private void writeShort(short s) throws IOException {
        this.out.write((s & 0xFF) >>> 0);
        this.out.write((s & 0xFF00) >>> 8);
    }

    @Override
    public boolean close() {
        boolean bl = true;
        try {
            this.out.seek(4L);
            int n = 36 + this.data_length;
            this.writeInt(n);
            this.out.seek(40L);
            this.writeInt(this.data_length);
            this.out.setLength(44 + this.data_length);
            this.out.close();
            this.out = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public int write(byte[] byArray, int n, int n2) throws IOException {
        this.data_length += n2;
        this.out.write(byArray, n, n2);
        return byArray.length;
    }
}

