/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.util.io;

import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends Writer {
    private static final String INDENT = "  ";
    private String indent = "";
    private Writer writer;
    private char lastChar = (char)32;

    public IndentingWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            char c = cArray[i];
            if (this.lastChar == '\n') {
                this.writer.write(this.indent);
            }
            this.writer.write(c);
            this.lastChar = c;
        }
    }

    public void writeln() throws IOException {
        this.write("\n");
    }

    public void writeln(String string) throws IOException {
        this.write(string);
        this.write("\n");
    }

    public void writeRaw(String string) throws IOException {
        this.writer.write(string);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void indent() {
        this.indent = this.indent + INDENT;
    }

    public void unindent() {
        if (this.indent.length() >= INDENT.length()) {
            this.indent = this.indent.substring(2);
        }
    }
}

