/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.util.io;

import com.vwp.sound.mod.util.io.AbstractRandomAccess;
import java.io.IOException;

public class RandomAccessArray
extends AbstractRandomAccess {
    private byte[] data;
    private int pos;

    public RandomAccessArray(byte[] byArray) {
        this.data = byArray;
        this.pos = 0;
    }

    @Override
    public void seek(long l) throws IOException {
        this.checkBounds(l);
        this.pos = (int)l;
    }

    @Override
    public void skipBytes(int n) throws IOException {
        this.checkBounds(this.pos + n);
        this.pos += n;
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    private void checkBounds(long l) throws IOException {
        if (l < 0L || l >= (long)this.data.length) {
            throw new IOException("Array index out of bounds: " + l);
        }
    }

    @Override
    public byte readByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new IOException("End of data");
        }
        return (byte)n;
    }

    @Override
    public short readShort() throws IOException {
        return (short)(this.readByte() << 8 | this.readByte());
    }

    @Override
    public int readInt() throws IOException {
        return this.readByte() << 24 | this.readByte() << 16 | this.readByte() << 8 | this.readByte() << 0;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.read() & 0xFF;
    }

    @Override
    public int read() throws IOException {
        this.checkBounds(this.pos);
        return this.data[this.pos++] & 0xFF;
    }

    @Override
    public void close() {
    }
}

