/*
 * Decompiled with CFR 0.152.
 */
package examples.applet;

import com.vwp.sound.mod.modplay.Player;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.sound.output.JavaSoundOutput;
import com.vwp.sound.mod.sound.output.SoundDataFormat;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AppletPlayer
extends Applet
implements ActionListener {
    public static final int BITS = 16;
    public static final int RATE = 44100;
    public static final int CHANNELS = 2;
    public static final boolean INTERPOLATE = true;
    public static final int BUFFERSIZE = 500;
    private Module module;
    private PlayerThread pt;
    private URL theUrl;
    private JButton pauseButton;
    private JButton stopButton;
    private JButton playButton;
    private JButton nextButton;
    private JButton prevButton;
    private JLabel moduleLabel;
    private String protocol;
    private String host;
    private int port;
    private List fileList = new ArrayList();
    private int nextModule = 0;

    @Override
    public void init() {
        this.protocol = this.getParameter("protocol");
        this.host = this.getParameter("host");
        this.port = Integer.parseInt(this.getParameter("port"));
        StringTokenizer stringTokenizer = new StringTokenizer(this.getParameter("files"), ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.fileList.add(stringTokenizer.nextToken());
        }
        this.module = this.loadModule(this.nextModule++);
        this.setLayout(new BorderLayout());
        this.moduleLabel = new JLabel(this.module.getName());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JLabel("JMOD"));
        jPanel.add(this.moduleLabel);
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.playButton = new JButton(">");
        this.playButton.addActionListener(this);
        this.pauseButton = new JButton("\u2225");
        this.pauseButton.addActionListener(this);
        this.stopButton = new JButton("\u25a1");
        this.stopButton.addActionListener(this);
        this.nextButton = new JButton("\u226b");
        this.nextButton.addActionListener(this);
        this.prevButton = new JButton("\u226a");
        this.prevButton.addActionListener(this);
        jPanel2.add(this.playButton);
        jPanel2.add(this.pauseButton);
        jPanel2.add(this.stopButton);
        jPanel2.add(this.prevButton);
        jPanel2.add(this.nextButton);
        this.add((Component)jPanel2, "South");
        this.pt = this.createPlayerThread(this.module);
        this.pt.start();
    }

    private PlayerThread createPlayerThread(Module module) {
        Player player = new Player();
        try {
            player.init(new JavaSoundOutput(new SoundDataFormat(16, 44100, 2), 500), true);
            player.load(module);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PlayerThread playerThread = new PlayerThread(player);
        playerThread.pause(true);
        return playerThread;
    }

    private Module loadModule(int n) {
        int n2 = this.fileList.size();
        while (n <= 0) {
            n += n2;
        }
        try {
            this.theUrl = new URL(this.protocol, this.host, this.port, (String)this.fileList.get((n + n2) % n2));
            return ModuleLoader.getModuleLoader(this.theUrl).getModule();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void start() {
        this.pt.pause(false);
    }

    @Override
    public void stop() {
        this.pt.pause(true);
    }

    @Override
    public void destroy() {
        this.pt.quit();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pauseButton) {
            this.pt.pause(!this.pt.isPause());
        } else if (actionEvent.getSource() == this.stopButton) {
            this.pt.quit();
        } else if (actionEvent.getSource() == this.playButton) {
            if (!this.pt.isRunning()) {
                this.pt = this.createPlayerThread(this.module);
                this.pt.pause(false);
                this.pt.start();
            } else if (this.pt.isPause()) {
                this.pt.pause(false);
            }
        } else if (actionEvent.getSource() == this.nextButton) {
            this.pt.quit();
            this.module = this.loadModule(this.nextModule++);
            this.moduleLabel.setText(this.module.getName());
            this.validate();
            this.pt = this.createPlayerThread(this.module);
            this.pt.start();
            this.pt.pause(false);
        } else if (actionEvent.getSource() == this.prevButton) {
            this.pt.quit();
            this.module = this.loadModule(this.nextModule--);
            this.moduleLabel.setText(this.module.getName());
            this.validate();
            this.pt = this.createPlayerThread(this.module);
            this.pt.start();
            this.pt.pause(false);
        }
    }

    private static class PlayerThread
    extends Thread {
        private Player player;
        private boolean run = true;
        private boolean pause = false;

        public PlayerThread(Player player) {
            this.player = player;
        }

        @Override
        public void run() {
            while (this.run) {
                if (!this.pause) {
                    try {
                        if (this.player.play()) continue;
                        break;
                    }
                    catch (PlayerException playerException) {
                        playerException.printStackTrace();
                        continue;
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.run = false;
            this.player.close();
        }

        public void quit() {
            this.run = false;
        }

        public void pause(boolean bl) {
            this.pause = bl;
        }

        public boolean isPause() {
            return this.pause;
        }

        public boolean isRunning() {
            return this.run;
        }
    }
}

