/*
 * Decompiled with CFR 0.152.
 */
package examples.cli;

import com.vwp.sound.mod.modplay.PlayList;
import com.vwp.sound.mod.modplay.Scope;
import com.vwp.sound.mod.sound.output.JavaSoundOutput;
import com.vwp.sound.mod.sound.output.Output;
import com.vwp.sound.mod.sound.output.SoundDataFormat;
import com.vwp.sound.mod.sound.output.WavOutput;
import com.vwp.sound.mod.util.Util;
import java.util.StringTokenizer;

public class Player {
    private static com.vwp.sound.mod.modplay.Player player;
    private static boolean random;
    private static int channels;
    private static String modName;
    private static boolean interpolate;
    private static int rate;
    private static int bits;
    private static double volume;
    private static double balance;
    private static double separation;
    private static int bufferTime;
    private static boolean[] mute;
    private static int startPosition;
    private static boolean onlyInfo;
    private static boolean verbose;
    private static boolean debug;
    private static double amplification;
    private static boolean writewav;
    private static long maxtime;
    private static String bug;
    private static String usage;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(usage);
            Util.exit(1);
        }
        try {
            PlayList playList = null;
            playList = Player.isList(stringArray[stringArray.length - 1]) ? new PlayList(stringArray[stringArray.length - 1]) : new PlayList(new String[]{stringArray[stringArray.length - 1]});
            while (playList.hasNext()) {
                Player.initialize(stringArray, playList);
                player = new com.vwp.sound.mod.modplay.Player();
                SoundDataFormat soundDataFormat = new SoundDataFormat(bits, rate, channels);
                Output output = writewav ? new WavOutput(modName + ".wav", soundDataFormat) : new JavaSoundOutput(soundDataFormat, bufferTime);
                if (!player.init(output, interpolate)) {
                    throw new Exception("could not init player");
                }
                if (!player.load(modName)) {
                    throw new Exception("could not load module");
                }
                if (onlyInfo) continue;
                player.setPosition(startPosition);
                player.setBalance(balance);
                player.setVolume(volume);
                player.setSeparation(separation);
                if (amplification >= 0.0) {
                    player.setAmplification(amplification);
                }
                player.mute(mute);
                int n = player.getModule().getTrackCount();
                Scope scope = new Scope(n, bufferTime + 200);
                long l = System.currentTimeMillis();
                while (maxtime == -1L || System.currentTimeMillis() - l <= maxtime) {
                    int n2 = player.getPosition();
                    int n3 = player.getDivision();
                    int n4 = player.getTick();
                    if (n4 == 0) {
                        scope.next();
                        for (int i = 0; i < n; ++i) {
                            if (player.getNote(i) == -2) continue;
                            scope.poke(i);
                        }
                    }
                    if (player.play()) continue;
                }
                player.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\n" + bug);
            System.exit(1);
        }
        Util.exit(0);
    }

    private static void initialize(String[] stringArray, PlayList playList) throws Exception {
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i].startsWith("amp")) {
                amplification = (double)Integer.parseInt(stringArray[i].substring(3)) / 100.0;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("quiet")) {
                verbose = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("debug")) {
                debug = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("info")) {
                onlyInfo = true;
                continue;
            }
            if (stringArray[i].startsWith("mute")) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i].substring(4), ":");
                while (stringTokenizer.hasMoreTokens()) {
                    Player.mute[Integer.parseInt((String)stringTokenizer.nextToken())] = true;
                }
                continue;
            }
            if (stringArray[i].startsWith("mono")) {
                channels = 1;
                continue;
            }
            if (stringArray[i].startsWith("pattern")) {
                startPosition = Integer.parseInt(stringArray[i].substring(7));
                continue;
            }
            if (stringArray[i].startsWith("rate")) {
                int n = Integer.parseInt(stringArray[i].substring(4));
                if (n != 11025 && n != 44100 && n != 22050) {
                    throw new Exception("rate must be 11025, 22050 or 44100");
                }
                rate = n;
                continue;
            }
            if (stringArray[i].startsWith("bits")) {
                int n = Integer.parseInt(stringArray[i].substring(4));
                if (n != 8 && n != 16) {
                    throw new Exception("bits must be 8 or 16");
                }
                bits = n;
                continue;
            }
            if (stringArray[i].equals("random")) {
                random = true;
                continue;
            }
            if (stringArray[i].startsWith("noint")) {
                interpolate = false;
                continue;
            }
            if (stringArray[i].startsWith("maxtime")) {
                maxtime = Integer.parseInt(stringArray[i].substring(7)) * 60 * 1000;
                continue;
            }
            if (stringArray[i].startsWith("volume")) {
                int n = Integer.parseInt(stringArray[i].substring(6));
                if (n < 0 || n > 255) {
                    throw new Exception("volume must be 0-100");
                }
                volume = (double)n / 100.0;
                continue;
            }
            if (stringArray[i].startsWith("balance")) {
                int n = Integer.parseInt(stringArray[i].substring(7));
                if (n < -100 || n > 100) {
                    throw new Exception("balance must be -100 - 100");
                }
                balance = (double)n / 200.0 + 0.5;
                continue;
            }
            if (stringArray[i].startsWith("seperation")) {
                int n = Integer.parseInt(stringArray[i].substring(10));
                if (n < 0 || n > 100) {
                    throw new Exception("seperation must be 0-100");
                }
                separation = (double)n / 100.0;
                continue;
            }
            if (stringArray[i].startsWith("buffer")) {
                int n;
                bufferTime = n = Integer.parseInt(stringArray[i].substring(6));
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("wav")) continue;
            writewav = true;
        }
        modName = !random ? playList.nextFileName() : playList.getRandomFileName();
        if (separation == -1.0) {
            if (modName.toLowerCase().endsWith(".xm")) {
                separation = 1.0;
            } else if (modName.toLowerCase().endsWith(".mod")) {
                separation = 0.5;
            } else if (modName.toLowerCase().endsWith(".s3m")) {
                separation = 1.0;
            }
        }
    }

    private static boolean isList(String string) {
        return string.toLowerCase().endsWith(".lst") || string.toLowerCase().endsWith(".list") || string.toLowerCase().endsWith(".txt");
    }

    private static String pad(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        for (int i = n; i != 0 && n3++ < n2; i /= 10) {
            stringBuffer.insert(0, i % 10);
        }
        while (n3++ < n2) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    static {
        random = false;
        channels = 2;
        interpolate = true;
        rate = 44100;
        bits = 16;
        volume = 1.0;
        balance = 0.5;
        separation = -1.0;
        bufferTime = 500;
        mute = new boolean[256];
        startPosition = 0;
        onlyInfo = false;
        verbose = true;
        debug = false;
        amplification = -1.0;
        writewav = false;
        maxtime = -1L;
        bug = "\nAn error has occured. Please report bugs at:\nhttps://jmod.dev.java.net/\nor email oxygenic@jmod.dev.java.net\n";
        usage = "usage:  java com.vwp.sound.mod.modplay.Player [options] <modname|playlist>\n        modname is the filename of a module (.mod or .xm)\n        playlist a file containing a list of modules separated by newlines\noptions:\n\tampX            - set amplification in percent, (0 - inf)\n\t                  [#tracks*100/4]\n\tbalanceX        - set balance, (-100 - 100) [0]\n\tbitsX           - 8 or 16 bits playback [16]\n\tbufferX         - set size of buffer to X milliseconds [500]\n\tdebug           - display debug information\n\tinfo            - show module info, don't play\n\tnoint           - don't use interpolation\n\tmaxtimeX        - exit/go to the module itf it has been\n\t                  playing for more than X minutes\n\tmono            - play module in mono\n\tmuteX[:Y...]    - mute track X [and Y and...]\n\tpatternX        - start playing at pattern X [0]\n\tquiet           - don't display any information\n\trandom          - play modules from the playlist in random order\n\trateX           - mix at rate X (X = <11025|22050|44100>) [44100]\n\tseperationX     - set the seperation of the channels.\n\t                  0 = mono, 100 = \"total\" stereo (0-100)\n\t                  [100 for .xm, 50 for .mod]\n\tvolumeX         - set volume to X (0-100) [100]\n\twav             - write to a wav file instead of speakers\n";
    }
}

