import java.awt.FileDialog;
import java.awt.Frame;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.*;

public class Interface {
	private static final long serialVersionUID = 1L;

	Window window;
	Map map = new Map();

	Interface() {
		window = new Window(this);
	}

	public static void main(String[] args) {
		Interface p = new Interface();
		p.run();
	}

	private void run() {
		window.setWindow();
	}

	public void loadGPX() {
		Frame frame = new Frame();
		FileDialog fileDialog = new FileDialog(frame, "open GPX", FileDialog.LOAD);
		fileDialog.setVisible(true);
		String gpxPath = fileDialog.getDirectory() + fileDialog.getFile();
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

		Vector<Point> points = new Vector<Point>();

		try {
			DocumentBuilder builder = factory.newDocumentBuilder();

			Document library = builder.parse(gpxPath);

			// renvoie la racine du doc
			Element root = library.getDocumentElement();

			// NodeList liste = root.getChildNodes();
			Element[] tracks = getElementsByTagName(root, "trk");
			for (int i = 0; i < tracks.length; i++) {
				Element[] segment = getElementsByTagName(root, "trkseg");
				for (int j = 0; j < segment.length; j++) {
					Element[] point = getElementsByTagName(root, "trkpt");
					for (int k = 0; k < point.length; k++) {
						double lat = Float.parseFloat(point[k]
								.getAttribute("lat"));
						double lon = Float.parseFloat(point[k]
								.getAttribute("lon"));
						points.add(new Point(lat, lon));
					}
				}
			}

		} catch (Exception e) {
			System.out.println("exception : " + e.getMessage());
		}

		map.display(points);

	}

	Element[] getElementsByTagName(Element baseElement, String name) {
		Vector<Element> elements = new Vector<Element>();
		NodeList list = baseElement.getElementsByTagName(name);
		for (int i = 0; i < list.getLength(); i++) {
			Node node = list.item(i);
			if (node.getNodeType() == Node.ELEMENT_NODE) {
				elements.add((Element) node);
			}
		}
		Element[] result = new Element[elements.size()];
		for (int i = 0; i < elements.size(); i++) {
			result[i] = elements.get(i);
		}
		return result;
	}

}

class Point {

	double y;
	double x;

	public Point(double lat, double lon) {
		this.y = lat;
		this.x = lon;
	}

}
