import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JPanel;

public class Map extends Canvas {
	private static final long serialVersionUID = 1L;

	private BufferStrategy strategy;
	private Graphics2D g;
	int width = 300;
	int height = 300;

	public Map() {
		JFrame container = new JFrame("GPS map");
		JPanel panel = (JPanel) container.getContentPane();
		panel.setPreferredSize(new Dimension(width, height));
		panel.setLayout(null);
		setBounds(0, 0, width, height);
		panel.add(this);
		setIgnoreRepaint(true);
		container.pack();
		container.setResizable(false);
		container.setVisible(true);
		container.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		requestFocus();
		createBufferStrategy(2);
		strategy = getBufferStrategy();
	}

	void display(Vector<Point> points) {
		g = (Graphics2D) strategy.getDrawGraphics();
		g.setStroke(new BasicStroke(1.0f));
		g.setColor(new Color(0x000000));
		g.fillRect(0, 0, width, height);
		g.setColor(Color.white);
		for (int i = 0; i < points.size(); i++) {
			int posX = (int) Math.floor((points.get(i).x) * 10000) % width;
			int posY = (int) Math.floor((points.get(i).y) * 10000) % height;
			System.out.println(i + " / " + points.size());
			g.draw(new Rectangle(posX, posY, 2, 2));
		}
		g.dispose();
		strategy.show();
	}

}
