
import gifAnimation.*;

import processing.video.*;
Capture cam;

ArrayList<PImage> captFrames = new ArrayList<PImage>();

PImage orig;
PImage flipped;

ArrayList<PImage> frames = new ArrayList<PImage>();

void setup() {
  size(800, 600, JAVA2D);
  colorMode(RGB);
  frameRate(10);
  // camera
  try {
    String[] cameras = Capture.list();
    for (int i=0; i<cameras.length; i++) println(nf(i, 3)+" "+cameras[i]);
    cam = new Capture(this, cameras[0]);
    cam.start();
  } 
  catch(Exception e) {
    println("cam : "+e);
  }
  flipped = createImage(width, height, RGB);
  orig = createImage(cam.width, cam.height, RGB);
}

void draw() {
  if (cam.available() == true) {
    cam.read();
    orig = cam.get();
    flipped = createImage(orig.width, orig.height, RGB);
    for (int x=0; x<orig.width; x++) {
      for (int y=0; y<orig.height; y++) {
        flipped.set(x, y, orig.get(orig.width-x-1, y));
      }
    }
    flipped.resize(width, height);
  }
  image(flipped, 0, 0, width, height);
  noStroke();
  fill(0, 0xFF, 0xFF);
  rect(0, height-10, (float)frames.size()/10*width, 10);
}

PVector finalGifSize = new PVector(500, 500);
void keyPressed() {
  if (frames.size()<10) {
    frames.add(orig.get());
  } else {
    String[] files = getAllFilesFrom(sketchPath("../export"));
    int firstFree=0;
    try {
      for (String file : files) {
        if (!file.substring(file.length()-5, file.length()).equals("Store")) firstFree = max(firstFree, Integer.parseInt(file.substring(file.length()-9, file.length()-4))+1);
      }
    }
    catch(Exception e) {
      println("save file : "+e);
    }
    String exportUrl = sketchPath("../export/result"+nf(firstFree, 5)+".gif");
    GifMaker gifExport = new GifMaker(this, exportUrl);
    gifExport.setRepeat(0);
    gifExport.setQuality(10);
    for (int i=0; i<frames.size (); i++) {
      PGraphics resized = createGraphics(floor(finalGifSize.x), floor(finalGifSize.y), JAVA2D);
      resized.beginDraw();
      resized.image(frames.get(i), 0, 0, floor(finalGifSize.x), floor(finalGifSize.y));
      resized.endDraw();
      gifExport.addFrame(resized.get());
      gifExport.setDelay(1);
    }
    gifExport.finish();
    frames.clear();
  }
}

import java.io.File;

String[] getAllFilesFrom(String folderUrl) {
  File folder = new File(folderUrl);
  File[] filesPath = folder.listFiles();
  String[] result = new String[filesPath.length];
  for (int i=0; i<filesPath.length; i++) {
    result[i]=filesPath[i].toString();
  }
  return result;
}
