
import gifAnimation.*;

int nbSimAnim = 32;

PImage[][] allAnims;// anim

int frameNb=0;

int picMargin=10;

float downSpeed = 3.0f;

String[] allFiles = new String[1];

boolean requestRefresh = true;

void setup() {
  size(800, 600);
  frame.setResizable(true);
  frame.setLocation(500, 500);
  frameRate(30);
  allAnims = new PImage[nbSimAnim][];
  allFiles[0]="";
  refreshPics();
}

void draw() {
  background(0);
  int currentX=picMargin;
  int currentY=picMargin;
  for (int i=0; i<nbSimAnim; i++) {
    if (allAnims[i]!=null) {
      if (allAnims[i].length>0) {
        try {
          PImage thisPic = allAnims[i][floor((float)frameNb/downSpeed)%allAnims[i].length];
          image(thisPic, currentX, currentY, thisPic.width, thisPic.height);
          currentX+=thisPic.width+picMargin;
          if (currentX+thisPic.width>=width) {
            currentY += thisPic.height+picMargin;
            currentX = picMargin;
            if (currentY+thisPic.height>=height) {
              break;
            }
          }
        } 
        catch(Exception e) {
          requestRefresh=true;
          allFiles = new String[1];
        }
      } else {
        requestRefresh=true;
        allFiles = new String[1];
      }
    } else {
      if (i==0) {
        requestRefresh=true;
        allFiles = new String[1];
      }
    }
  }
  if (allAnims.length>=2) {
    if (allAnims[0]!=null&&allAnims[1]!=null) {
      if (allAnims[0].length!=allAnims[1].length) {
        requestRefresh=true;
        allFiles = new String[1];
      }
    }
  }
  if (frameNb%50==0) requestRefresh=true;
  if (requestRefresh) refreshPics();
  frameNb++;
}

void refreshPics() {
  try {
    String[] allNewFiles = reverse(sort(getAllFilesFrom(dataPath("../../export"))));
    if (allNewFiles.length>0) {
      if (!allNewFiles[0].equals(allFiles[0]) || allNewFiles.length!=allFiles.length) {
        println(allNewFiles[0]+" "+allNewFiles.length);
        // if (!allNewFiles[i].substring(allNewFiles[i].length()-5, allNewFiles[i].length()).equals("Store")) 
        for (int i=0; i<min (nbSimAnim, allNewFiles.length); i++) allAnims[i] = Gif.getPImages(this, allNewFiles[i]);
        requestRefresh=false;
      }
    }
    allFiles = allNewFiles;
  }
  catch(Exception e) {
    println("refresh pics : "+e);
  }
}

