/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.IOException;

class DataOutputStreamLittleEndian {
    private DataOutputStream systemStream;

    public DataOutputStreamLittleEndian(DataOutputStream dataOutputStream) {
        this.systemStream = dataOutputStream;
    }

    public void close() throws IOException {
        this.systemStream.close();
    }

    public void writeString(String string) throws IOException {
        this.systemStream.writeBytes(string);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.systemStream.write(byArray, 0, byArray.length);
    }

    public void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        this.systemStream.write(byArray, 0, 4);
    }

    public void writeShort(short s) throws IOException {
        byte[] byArray = new byte[]{(byte)s, (byte)(s >>> 8 & 0xFF)};
        this.systemStream.write(byArray, 0, 2);
    }
}

