/*
 * Decompiled with CFR 0.152.
 */
abstract class Sample {
    Sample() {
    }

    public abstract Sample buildFromBytes(byte[] var1);

    public abstract Sample buildFromDouble(double var1);

    public abstract byte[] convertToBytes();

    public abstract double convertToDouble();

    public static Sample[][] buildManyFromDoubles(SamplingInfo samplingInfo, double[][] dArray) {
        int n = dArray.length;
        Sample[][] sampleArray = new Sample[n][];
        int n2 = dArray[0].length;
        int n3 = 0;
        while (n3 < n) {
            sampleArray[n3] = new Sample[n2];
            ++n3;
        }
        Sample sample = samplingInfo.samplePrototype();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                sampleArray[n5][n4] = sample.buildFromDouble(dArray[n5][n4]);
                ++n5;
            }
            ++n4;
        }
        return sampleArray;
    }

    public static Sample[][] buildManyFromBytes(SamplingInfo samplingInfo, byte[] byArray) {
        int n = byArray.length;
        int n2 = samplingInfo.numberOfChannels;
        Sample[][] sampleArray = new Sample[n2][];
        int n3 = samplingInfo.bitsPerSample / 8;
        int n4 = n / n3 / n2;
        int n5 = 0;
        while (n5 < n2) {
            sampleArray[n5] = new Sample[n4];
            ++n5;
        }
        n5 = 0;
        Math.pow(2.0, 8 * n3 - 1);
        Sample sample = samplingInfo.samplePrototype();
        byte[] byArray2 = new byte[n3];
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < n2) {
                int n8 = 0;
                while (n8 < n3) {
                    byArray2[n8] = byArray[n5];
                    ++n5;
                    ++n8;
                }
                sampleArray[n7][n6] = sample.buildFromBytes(byArray2);
                ++n7;
            }
            ++n6;
        }
        return sampleArray;
    }

    public static Sample[] concatenateSets(Sample[][] sampleArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < sampleArray.length) {
            Sample[] sampleArray2 = sampleArray[n2];
            n += sampleArray2.length;
            ++n2;
        }
        Sample[] sampleArray3 = new Sample[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < sampleArray.length) {
            Sample[] sampleArray4 = sampleArray[n4];
            int n5 = 0;
            while (n5 < sampleArray4.length) {
                sampleArray3[n3] = sampleArray4[n5];
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return sampleArray3;
    }

    public static byte[] convertManyToBytes(Sample[][] sampleArray, SamplingInfo samplingInfo) {
        byte[] byArray = null;
        int n = samplingInfo.numberOfChannels;
        int n2 = sampleArray[0].length;
        short s = samplingInfo.bitsPerSample;
        int n3 = s / 8;
        int n4 = n * n2 * n3;
        byArray = new byte[n4];
        Math.pow(2.0, 8 * n3 - 1);
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n) {
                Sample sample = sampleArray[n7][n6];
                byte[] byArray2 = sample.convertToBytes();
                int n8 = 0;
                while (n8 < n3) {
                    byArray[n5] = byArray2[n8];
                    ++n5;
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        return byArray;
    }

    public static Sample[] superimposeSets(Sample[][] sampleArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < sampleArray.length) {
            Sample[] sampleArray2 = sampleArray[n2];
            if (sampleArray2.length > n) {
                n = sampleArray2.length;
            }
            ++n2;
        }
        Sample[] sampleArray3 = new Sample[n];
        int n3 = 0;
        while (n3 < sampleArray.length) {
            Sample[] sampleArray4 = sampleArray[n3];
            int n4 = 0;
            while (n4 < sampleArray4.length) {
                Sample sample = sampleArray4[n4];
                double d = sample.convertToDouble();
                if (n3 > 0) {
                    d += sampleArray3[n3].convertToDouble();
                }
                sampleArray3[n3] = sample.buildFromDouble(d);
                ++n4;
            }
            ++n3;
        }
        return sampleArray3;
    }
}

