/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class WavFile {
    public String filePath;
    public SamplingInfo samplingInfo;
    public Sample[][] samplesForChannels;

    public WavFile(String string, SamplingInfo samplingInfo, Sample[][] sampleArray) {
        this.filePath = string;
        this.samplingInfo = samplingInfo;
        this.samplesForChannels = sampleArray;
    }

    public double[][] samplesAsDouble() {
        double[][] dArrayArray = new double[this.samplesForChannels.length][];
        int n = 0;
        while (n < this.samplesForChannels.length) {
            dArrayArray[n] = new double[this.samplesForChannels[n].length];
            int n2 = 0;
            while (n2 < this.samplesForChannels[n].length) {
                dArrayArray[n][n2] = this.samplesForChannels[n][n2].convertToDouble();
                ++n2;
            }
            ++n;
        }
        return dArrayArray;
    }

    public void setSamplesFromDouble(double[][] dArray) {
        this.samplesForChannels = Sample.buildManyFromDoubles(this.samplingInfo, dArray);
    }

    public static WavFile readFromFilePath(String string) {
        WavFile wavFile = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            DataInputStreamLittleEndian dataInputStreamLittleEndian = new DataInputStreamLittleEndian(dataInputStream);
            byte[] byArray = new byte[4];
            dataInputStreamLittleEndian.read(byArray);
            dataInputStreamLittleEndian.readInt();
            byte[] byArray2 = new byte[4];
            dataInputStreamLittleEndian.read(byArray2);
            byte[] byArray3 = new byte[4];
            dataInputStreamLittleEndian.read(byArray3);
            int n = dataInputStreamLittleEndian.readInt();
            Short s = dataInputStreamLittleEndian.readShort();
            Short s2 = dataInputStreamLittleEndian.readShort();
            int n2 = dataInputStreamLittleEndian.readInt();
            dataInputStreamLittleEndian.readInt();
            dataInputStreamLittleEndian.readShort();
            Short s3 = dataInputStreamLittleEndian.readShort();
            byte[] byArray4 = new byte[4];
            dataInputStreamLittleEndian.read(byArray4);
            int n3 = dataInputStreamLittleEndian.readInt();
            byte[] byArray5 = new byte[n3];
            dataInputStreamLittleEndian.read(byArray5);
            dataInputStreamLittleEndian.close();
            SamplingInfo samplingInfo = new SamplingInfo("[from file]", n, s, s2, n2, s3);
            Sample[][] sampleArray = Sample.buildManyFromBytes(samplingInfo, byArray5);
            wavFile = new WavFile(string, samplingInfo, sampleArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return wavFile;
    }

    public void writeToFilePath(String string) {
        this.filePath = string;
        this.writeToFilePath();
    }

    public void writeToFilePath() {
        try {
            int n = this.samplesForChannels[0].length * this.samplingInfo.numberOfChannels * this.samplingInfo.bitsPerSample / 8;
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.filePath)));
            DataOutputStreamLittleEndian dataOutputStreamLittleEndian = new DataOutputStreamLittleEndian(dataOutputStream);
            dataOutputStreamLittleEndian.writeString("RIFF");
            dataOutputStreamLittleEndian.writeInt(n + 36);
            dataOutputStreamLittleEndian.writeString("WAVE");
            dataOutputStreamLittleEndian.writeString("fmt ");
            dataOutputStreamLittleEndian.writeInt(this.samplingInfo.chunkSize);
            dataOutputStreamLittleEndian.writeShort(this.samplingInfo.formatCode);
            dataOutputStreamLittleEndian.writeShort(this.samplingInfo.numberOfChannels);
            dataOutputStreamLittleEndian.writeInt(this.samplingInfo.samplesPerSecond);
            dataOutputStreamLittleEndian.writeInt(this.samplingInfo.bytesPerSecond());
            dataOutputStreamLittleEndian.writeShort((short)(this.samplingInfo.numberOfChannels * this.samplingInfo.bitsPerSample / 8));
            dataOutputStreamLittleEndian.writeShort(this.samplingInfo.bitsPerSample);
            dataOutputStreamLittleEndian.writeString("data");
            dataOutputStreamLittleEndian.writeInt(n);
            byte[] byArray = Sample.convertManyToBytes(this.samplesForChannels, this.samplingInfo);
            dataOutputStreamLittleEndian.writeBytes(byArray);
            dataOutputStreamLittleEndian.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

