

void setup() {
  String[] params = loadStrings("params.txt");

  String filePath = params[1]; // put the file in the sketch folder
  int nbParts = int(params[3]); // number of parts
  String baseRName = params[5]; // first part of the resulting files names

  WavFile baseFile = WavFile.readFromFilePath(sketchPath(filePath));
  double[][] waveForm = baseFile.samplesAsDouble();

  for (int i=0;i<nbParts;i++) {
    double[][] thisPart = new double[waveForm.length][floor((float)waveForm[0].length/nbParts)];
    for (int c=0;c<waveForm.length;c++) {    
      for (int j = 0 ; j < floor((float)waveForm[c].length/nbParts) ; j++) {
        thisPart[c][j] = waveForm[c][floor((float)waveForm[c].length*i/nbParts) + j];
      }
    }
    baseFile.setSamplesFromDouble(thisPart);
    baseFile.writeToFilePath(sketchPath(baseRName+nf(i, 2)+".wav"));
  }
}

void draw() {
}

