<?php

function isAName($thisNameIn,$haystack) {
	$nameFound = false;
	for ($i=0 ; $i < $haystack->length && !$nameFound ; $i++) {
		$thisName = $haystack->item($i);
		if (strtolower(utf8_decode($thisName->getAttribute('text')))==strtolower($thisNameIn)) {
			$nameFound = true;
		}
	}
	return $nameFound;
}

$jsonInput = json_decode(file_get_contents('php://input'));
$thisNameInput = utf8_decode($jsonInput->{'sender'});
$allWordsInput = explode(' ',utf8_decode($jsonInput->{'plainText'}));

$allowedChars = array("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","z","0","1","2","3","4","5","6","7","8","9","?",".","!",":",";","","","","","","","","","","","","","<",">","\\","\/");

$baseXml = 'base.xml';
$doc = new DOMDocument();
$doc->Load($baseXml);

$names = $doc->documentElement->getElementsByTagName('name');
$sentences = $doc->documentElement->getElementsByTagName('sentence');

$nbWordsAdded=0;
for ($w=0;$w<count($allWordsInput);$w++) {
	
	$oneWordInput = $allWordsInput[$w];
	
	for ($i=0;$i<strlen($oneWordInput);$i++) if (!in_array(strtolower(substr($oneWordInput,$i,1)), $allowedChars)) $oneWordInput=substr($$oneWordInput,0,$i) . "!" . substr($oneWordInput,$i+1,0);

	if (strlen($oneWordInput)>0) {
		
		$placeFound = false;

		if ($w>0) {
			$prevWordInput = $allWordsInput[$w-1];
			for ($i=0 ; $i < $sentences->length && !$placeFound && $nbWordsAdded<3; $i++) {
				$thisSentence = $sentences->item($i);
				$words = $thisSentence->getElementsByTagName('word');
				if (strtolower(utf8_decode($words->item($words->length-1)->getAttribute('text')))==strtolower($prevWordInput)) {
					$thisWord = $doc->createElement('word');
					$thisWord->setAttribute('text', utf8_encode($oneWordInput));
					$thisWord->setAttribute('date', date(c));
					if (isAName($oneWordInput,$names)) $thisWord->setAttribute('isAName', "true");
					else $thisWord->setAttribute('isAName', "false");
					$thisSentence->appendChild($thisWord);
					$placeFound = true;
					$nbWordsAdded++;
				}
			}
		}

		if ($w==0) {
			for ($i=0 ; $i < $sentences->length && !$placeFound; $i++) {
				$thisSentence = $sentences->item($i);
				$words = $thisSentence->getElementsByTagName('word');
				if ($words->length>0) {
					if (strtolower(utf8_decode($words->item(0)->getAttribute('text')))==strtolower($oneWordInput)) {
						$placeFound = true;
					}
				}
			}
			if (!$placeFound) {
				$thisSentence = $doc->createElement('sentence');
				$thisWord = $doc->createElement('word');
				$thisWord->setAttribute('text', utf8_encode($oneWordInput));
				$thisWord->setAttribute('date', date(c));
				if (isAName($oneWordInput,$names)) $thisWord->setAttribute('isAName', "true");
				else $thisWord->setAttribute('isAName', "false");				
				$thisSentence->appendChild($thisWord);
				$doc->documentElement->appendChild($thisSentence);
				$placeFound = true;
				$nbWordsAdded++;
			}
		}
	}
	
}

if (!isAName($thisNameInput,$names)) {
	$thisName = $doc->createElement('name');
	$thisName->setAttribute('text', $thisNameInput);
	$thisName->setAttribute('date', date(c));
	$doc->documentElement->appendChild($thisName);		
}

// delete oldest last word
// delete this sentence if == 0

// limit number of sentences, delete the smallest ones + oldest ones ?
while ($sentences->length>500) {
	$smallestSentence=$sentences->item(0);
	$smallestI=-1;
	for ($i=0 ; $i < $sentences->length-200 ; $i++) {
		$thisSentence = $sentences->item($i);
		$words = $thisSentence->getElementsByTagName('word');
		if ($smallestI==-1||$words->length<$smallest) {
			$smallestI=$i;
			$smallest=$thisSentence;
		}
	}
	$doc->documentElement->removeChild($smallestSentence);
}

$doc->saveXML();
$doc->save($baseXml);

?>