﻿<?php

function isAName($thisNameIn,$haystack) {
	$nameFound = false;
	for ($i=0 ; $i < $haystack->length && !$nameFound ; $i++) {
		$thisName = $haystack->item($i);
		if (strtolower(utf8_decode($thisName->getAttribute('text')))==strtolower($thisNameIn)) {
			$nameFound = true;
		}
	}
	return $nameFound;
}

$jsonInput = json_decode(file_get_contents('php://input'));
$queryMessage = explode(' ',$jsonInput->{'queryMessage'});

$baseXml = 'base.xml';
$doc = new DOMDocument();
$doc->Load($baseXml);

$sentences = $doc->documentElement->getElementsByTagName('sentence');
$names = $doc->documentElement->getElementsByTagName('name');

// get most significant word in query
$significantWord = "";
for ($i=0;$i<count($queryMessage);$i++) {
	if (strlen($queryMessage[$i])>=strlen($significantWord)) {
		if (!isAName($queryMessage[$i],$names)) {
			$significantWord = $queryMessage[$i];
		}
	}
}

// TODO otherwise take latest addition

$chosenIndex = -1;
if ($sentences->length>0) {
	for ($j=0;$j<$sentences->length;$j++) {
		$thisSentence = $sentences->item($j);
		$words = $thisSentence->getElementsByTagName('word');
		for ($i=0;$i<$words->length && $chosenIndex==-1;$i++) {
			if (strtolower($words->item($i)->getAttribute('text'))==strtolower($significantWord)) $chosenIndex = $j;
		}
	}
}

$thisSentence = $sentences->item(rand(0,rand(0,$sentences->length-1)));
if ($chosenIndex!=-1) $thisSentence = $sentences->item($chosenIndex);

$theSentence="";
if ($sentences->length>0) {	
	$words = $thisSentence->getElementsByTagName('word');
	for ($i=0;$i<$words->length;$i++) {
		if ($words->item($i)->getAttribute('isAName')=='true') $theSentence.=$names->item(rand(0,$names->length-1))->getAttribute('text')." ";
		else $theSentence.=$words->item($i)->getAttribute('text')." ";
	}
	if ($sentences->length>3) $doc->documentElement->removeChild($thisSentence);
}

// TODO if sentence containing significant word not found, check twitter

echo $theSentence;

$doc->saveXML();
$doc->save($baseXml);

?>