/*
 * Decompiled with CFR 0.152.
 */
package gifAnimation;

import gifAnimation.GifDecoder;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class Gif
extends PImage
implements PConstants,
Runnable {
    private PApplet parent;
    Thread runner;
    private boolean play;
    private boolean loop;
    private boolean ignoreRepeatSetting = false;
    private int repeatSetting = 1;
    private int repeatCount = 0;
    private int currentFrame;
    private PImage[] frames;
    private int[] delays;
    private int lastJumpTime;
    private static String version = "2.3";

    public Gif(PApplet pApplet, String string) {
        super(1, 1, 2);
        this.parent = pApplet;
        GifDecoder gifDecoder = Gif.createDecoder(pApplet, string);
        this.frames = Gif.extractFrames(gifDecoder);
        this.delays = Gif.extractDelays(gifDecoder);
        this.repeatSetting = gifDecoder.getLoopCount();
        super.init(this.frames[0].width, this.frames[0].height, 2);
        this.jump(0);
        pApplet.registerDispose((Object)this);
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void dispose() {
        this.stop();
        this.runner = null;
    }

    public void run() {
        while (Thread.currentThread() == this.runner) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.play || this.parent.millis() - this.lastJumpTime < this.delays[this.currentFrame]) continue;
            if (this.currentFrame == this.frames.length - 1) {
                if (this.loop) {
                    this.jump(0);
                    continue;
                }
                if (!this.ignoreRepeatSetting) {
                    ++this.repeatCount;
                    if (this.repeatSetting == 0) {
                        this.jump(0);
                        continue;
                    }
                    if (this.repeatCount != this.repeatSetting) continue;
                    this.stop();
                    continue;
                }
                this.stop();
                continue;
            }
            this.jump(this.currentFrame + 1);
        }
    }

    private static InputStream createInputStream(PApplet pApplet, String string) {
        InputStream inputStream = pApplet.openStream(string);
        return inputStream;
    }

    public static PImage[] getPImages(PApplet pApplet, String string) {
        GifDecoder gifDecoder = Gif.createDecoder(pApplet, string);
        return Gif.extractFrames(gifDecoder);
    }

    public PImage[] getPImages() {
        return this.frames;
    }

    private static GifDecoder createDecoder(PApplet pApplet, String string) {
        GifDecoder gifDecoder = new GifDecoder();
        gifDecoder.read(Gif.createInputStream(pApplet, string));
        return gifDecoder;
    }

    private static PImage[] extractFrames(GifDecoder gifDecoder) {
        int n = gifDecoder.getFrameCount();
        PImage[] pImageArray = new PImage[n];
        for (int i = 0; i < n; ++i) {
            BufferedImage bufferedImage = gifDecoder.getFrame(i);
            pImageArray[i] = new PImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            System.arraycopy(bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth()), 0, pImageArray[i].pixels, 0, bufferedImage.getWidth() * bufferedImage.getHeight());
        }
        return pImageArray;
    }

    private static int[] extractDelays(GifDecoder gifDecoder) {
        int n = gifDecoder.getFrameCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gifDecoder.getDelay(i);
        }
        return nArray;
    }

    public void ignoreRepeat() {
        this.ignoreRepeatSetting = true;
    }

    public int getRepeat() {
        return this.repeatSetting;
    }

    public boolean isPlaying() {
        return this.play;
    }

    public int currentFrame() {
        return this.currentFrame;
    }

    public boolean isLooping() {
        return this.loop;
    }

    public boolean isIgnoringRepeat() {
        return this.ignoreRepeatSetting;
    }

    public static String version() {
        return version;
    }

    public void play() {
        this.play = true;
        if (!this.ignoreRepeatSetting) {
            this.repeatCount = 0;
        }
    }

    public void loop() {
        this.play = true;
        this.loop = true;
    }

    public void noLoop() {
        this.loop = false;
    }

    public void pause() {
        this.play = false;
    }

    public void stop() {
        this.play = false;
        this.currentFrame = 0;
        this.repeatCount = 0;
    }

    public void jump(int n) {
        if (this.frames.length > n) {
            this.currentFrame = n;
            this.loadPixels();
            System.arraycopy(this.frames[this.currentFrame].pixels, 0, this.pixels, 0, this.width * this.height);
            this.updatePixels();
            this.lastJumpTime = this.parent.millis();
        }
    }
}

