/*
 * Decompiled with CFR 0.152.
 */
package gifAnimation;

import gifAnimation.GifDecoder;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GifAnimation
extends PImage
implements PConstants,
Runnable {
    private PApplet parent;
    Thread runner;
    private boolean play;
    private boolean repeat;
    private int currentFrame;
    private int frameCount;
    private PImage[] frames;
    private int[] delays;
    private int lastJumpTime;

    public GifAnimation(PApplet pApplet, String string) {
        super(1, 1, 2);
        this.parent = pApplet;
        GifDecoder gifDecoder = GifAnimation.createDecoder(pApplet, string);
        this.frames = GifAnimation.extractFrames(gifDecoder);
        this.delays = GifAnimation.extractDelays(gifDecoder);
        super.init(this.frames[0].width, this.frames[0].height, 2);
        this.jump(0);
        pApplet.registerDispose((Object)this);
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void dispose() {
        this.stop();
        this.runner = null;
    }

    public void run() {
        while (Thread.currentThread() == this.runner) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.play || this.parent.millis() - this.lastJumpTime < this.delays[this.currentFrame]) continue;
            if (this.currentFrame == this.frames.length - 1) {
                if (this.repeat) {
                    this.jump(0);
                    continue;
                }
                this.stop();
                continue;
            }
            this.jump(this.currentFrame + 1);
        }
    }

    private static InputStream createInputStream(PApplet pApplet, String string) {
        InputStream inputStream = pApplet.openStream(string);
        return inputStream;
    }

    public static PImage[] getPImages(PApplet pApplet, String string) {
        GifDecoder gifDecoder = GifAnimation.createDecoder(pApplet, string);
        return GifAnimation.extractFrames(gifDecoder);
    }

    private static GifDecoder createDecoder(PApplet pApplet, String string) {
        GifDecoder gifDecoder = new GifDecoder();
        gifDecoder.read(GifAnimation.createInputStream(pApplet, string));
        return gifDecoder;
    }

    private static PImage[] extractFrames(GifDecoder gifDecoder) {
        int n = gifDecoder.getFrameCount();
        PImage[] pImageArray = new PImage[n];
        for (int i = 0; i < n; ++i) {
            BufferedImage bufferedImage = gifDecoder.getFrame(i);
            pImageArray[i] = new PImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            pImageArray[i].loadPixels();
            System.arraycopy(bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth()), 0, pImageArray[i].pixels, 0, bufferedImage.getWidth() * bufferedImage.getHeight());
            pImageArray[i].updatePixels();
        }
        return pImageArray;
    }

    private static int[] extractDelays(GifDecoder gifDecoder) {
        int n = gifDecoder.getFrameCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gifDecoder.getDelay(i);
        }
        return nArray;
    }

    public void play() {
        this.play = true;
    }

    public void loop() {
        this.play = true;
        this.repeat = true;
    }

    public void noLoop() {
        this.repeat = false;
    }

    public void pause() {
        this.play = false;
    }

    public void stop() {
        this.play = false;
        this.currentFrame = 0;
    }

    public void jump(int n) {
        this.currentFrame = this.frames.length > n ? n : this.frames.length - 1;
        this.loadPixels();
        System.arraycopy(this.frames[this.currentFrame].pixels, 0, this.pixels, 0, this.width * this.height);
        this.updatePixels();
        this.lastJumpTime = this.parent.millis();
    }
}

