import processing.core.*; 
import processing.xml.*; 

import java.awt.FileDialog; 
import gifAnimation.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class depthMapUser extends PApplet {


 


GifMaker gifExport;

public void setup() {
  background(0);
}

boolean done=false;

public void draw() {
  if (done) {
    exit();
  }
  else {
    String origUrl = getAFile("load original picture");
    String depthUrl = getAFile("load depth map");

    if (origUrl!=null && depthUrl!=null) {

      PImage orig = loadImage(origUrl);
      PImage depth = loadImage(depthUrl);
      float ratio = PApplet.parseFloat(parameter(0));
      float mid = PApplet.parseFloat(parameter(1));
      int mode = PApplet.parseInt(parameter(7));

      PImage lef = get3DPictureOf(orig, depth, -ratio, mid, ratio, mode, 0);
      PImage rig = get3DPictureOf(orig, depth, ratio, mid, ratio, mode, 0);
      lef.save("left.png");
      rig.save("right.png");

      PImage ana = createImage(orig.width, orig.height, RGB);
      for (int x=0;x<orig.width;x++) {
        for (int y=0;y<orig.height;y++) {
          ana.set(x, y, color(red(lef.get(x, y)), green(rig.get(x, y)), blue(rig.get(x, y))));
        }
      }
      ana.save("anaglyph.png");

      PImage noisy = createImage(orig.width, orig.height, RGB);
      int margin = floor(ratio*7);
      int inc=0;
      int randomColor = color(random(0xFF), random(0xFF), random(0xFF));
      for (int x=0;x<noisy.width;x++) {
        for (int y=0;y<noisy.height;y++) {
          randomColor = lerpColor(randomColor, color(((x^y)+random(0x80))%0xFF, (x*y+random(0x80))%0xFF, (x+y+random(0x80))%0xFF), 0.7f);
          noisy.set(x, y, randomColor);
          inc++;
        }
      }
      for (int x=noisy.width-1;x>=0;x--) {
        for (int y=0;y<noisy.height;y++) {
          float thisDepth = (float)brightness(depth.get(floor(((float)x)*depth.width/orig.width), floor(((float)y)*depth.height/orig.height)));
          noisy.set(x, y, getInterpolatedColor(noisy, (x+margin-thisDepth*ratio/0xFF+noisy.width)%noisy.width, y));
        }
      }
      noisy.save("autostereogram.png");

      PGraphics[] layers = new PGraphics[PApplet.parseInt(parameter(8))];
      for (int i=0;i<layers.length;i++) {
        layers[i] = createGraphics(orig.width, orig.height, JAVA2D);
        layers[i].beginDraw();
        for (int x=0;x<orig.width;x++) {
          for (int y=0;y<orig.height;y++) {
            float thisDepth = (float)brightness(depth.get(floor(((float)x)*depth.width/orig.width), floor(((float)y)*depth.height/orig.height)));
            float thisLayer = thisDepth*(float)layers.length/0xFF;
            if (thisLayer >= i) {
              layers[i].stroke(orig.get(x, y));
              layers[i].point(x, y);
            }
          }
        }
        layers[i].endDraw();        
        layers[i].save("layer"+nf(i, 3)+".png");
      }

      PImage cam = get3DPictureOf(orig, depth, ratio, mid, ratio, 1, 0);
      cam.save("camera.png");

      PImage orth = get3DPictureOf(orig, depth, ratio, mid, ratio, 0, PApplet.parseFloat(parameter(9)));
      orth.save("ortho.png");

      PImage[] anim = new PImage[PApplet.parseInt(parameter(2))];
      for (int i=0;i<anim.length;i++) {
        anim[i] = get3DPictureOf(orig, depth, (float)i*ratio/anim.length-ratio/2, mid, ratio/2, mode, 0);
      }

      gifExport = new GifMaker(this, "anim.gif");
      gifExport.setRepeat(0);
      gifExport.setQuality(20);
      for (int i=0;i<anim.length;i++) {
        gifExport.addFrame(anim[i]);
        gifExport.setDelay(1);
      }
      for (int i=anim.length-2;i>0;i--) {
        gifExport.addFrame(anim[i]);
        gifExport.setDelay(1);
      }
      gifExport.finish();

      float gap = PApplet.parseInt(parameter(3));
      PImage[] seq = new PImage[ceil(gap)];
      for (int i=0;i<seq.length;i++) {
        seq[i] = get3DPictureOf(orig, depth, (float)i*ratio/seq.length-ratio/2, mid, ratio/2, mode, 0);
      }

      int zoom = PApplet.parseInt(parameter(4));
      int bandThreshold = PApplet.parseInt(parameter(5));
      float contr = 1 - PApplet.parseFloat(parameter(6));
      PImage pyjama = createImage(orig.width*zoom, orig.height*zoom, RGB);
      for (int y=0;y<pyjama.height;y++) {
        int phase=0;    
        for (int x=0;x<pyjama.width;x++) {
          int thisSeqIm = floor(phase%gap);
          int c;
          if (brightness(seq[thisSeqIm].get(x/zoom, y/zoom))>bandThreshold) c = lerpColor(color(0xFF), seq[thisSeqIm].get(x/zoom, y/zoom), contr);
          else c = lerpColor(color(0x00), seq[thisSeqIm].get(x/zoom, y/zoom), contr);
          pyjama.set(x, y, c);
          phase++;
        }
      }
      pyjama.save("pyjama.png");
    }
    done = true;
  }
}

public int getInterpolatedColor(PImage im, float x, int y) {
  int c1 = im.get(constrain(floor(x), 0, im.width-1), y);
  int c2 = im.get(constrain( ceil(x), 0, im.width-1), y);
  float prop = x%1;
  return lerpColor(c1, c2, prop);
}

public String getAFile(String label) {
  Frame frame = new Frame();
  FileDialog fileDialog = new FileDialog(frame, label, FileDialog.LOAD);
  fileDialog.setVisible(true);
  if (fileDialog.getFile()!=null) {
    String filePath = fileDialog.getDirectory() + fileDialog.getFile();
    return filePath;
  }
  return null;
}

public String parameter(int p) {
  String txt = loadStrings("params.txt")[p];
  for (int i=0;i<txt.length();i++) {
    if (txt.charAt(i)=='/') txt = txt.substring(0, i);
  }
  while (txt.charAt (max (txt.length ()-1, 0))==' ') {
    txt = txt.substring(0, txt.length()-1);
  }
  return txt;
}

public PImage get3DPictureOf(PImage orig, PImage depth, float shif, float mid, float trimM, int mode, float rot) {
  PGraphics troide = createGraphics(orig.width, orig.height, P3D);
  troide.beginDraw();
  if (mode==0) {
    troide.ortho(trimM, orig.width-trimM, 0, orig.height, 0, 0x100);
    troide.translate(orig.width/2, orig.height/2, -0x100/2);
    troide.rotateY(rot);
    troide.rotateZ(-rot/5);
    troide.translate(0, rot*100, rot*100);
  }
  else if (mode==1 || mode==2) {
    troide.camera();
    troide.translate(0, 0, -0x100);
    int zoomIn=1;// feel free to zoom here
    troide.translate(orig.width/2, orig.height/2, 0);
    troide.scale(zoomIn);
    troide.translate(-orig.width/2, -orig.height/2, 0);
  }
  troide.noStroke();
  troide.noFill();
  troide.background(0);
  float thisDepth;
  for (int x=0;x<orig.width-1;x++) {
    for (int y=0;y<orig.height-1;y++) {      
      troide.beginShape();
      troide.texture(orig);
      thisDepth = (float)brightness(depth.get(floor(((float)x+0)*depth.width/orig.width), floor(((float)y+0)*depth.height/orig.height)));
      troide.vertex((x+0)-((thisDepth-mid*0xFF)*shif/0xFF), (y+0), thisDepth, x+0, y+0);
      thisDepth = (float)brightness(depth.get(floor(((float)x+1)*depth.width/orig.width), floor(((float)y+0)*depth.height/orig.height)));
      troide.vertex((x+1)-((thisDepth-mid*0xFF)*shif/0xFF), (y+0), thisDepth, x+1, y+0);
      thisDepth = (float)brightness(depth.get(floor(((float)x+1)*depth.width/orig.width), floor(((float)y+1)*depth.height/orig.height)));
      troide.vertex((x+1)-((thisDepth-mid*0xFF)*shif/0xFF), (y+1), thisDepth, x+1, y+1);
      thisDepth = (float)brightness(depth.get(floor(((float)x+0)*depth.width/orig.width), floor(((float)y+1)*depth.height/orig.height)));
      troide.vertex((x+0)-((thisDepth-mid*0xFF)*shif/0xFF), (y+1), thisDepth, x+0, y+1);
      troide.endShape();
    }
  }
  troide.endDraw();
  PImage im = createImage(orig.width, orig.height, RGB);
  im = troide.get();
  return im;
}

  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#D4D0C8", "depthMapUser" });
  }
}
