
import ddf.minim.*;
import ddf.minim.analysis.*;

Minim minim;
AudioSample track;

int currentTrack;

int nbCh = 2;

float[][] sL, sR;

int frame=0;

void setup() {
  // size(1920, 1080);
  size(1440, 810);
  frameRate(50);
  minim = new Minim(this);
  String[] files = getAllFilesFrom(dataPath("audio/"));
  initGenerate(dataPath(files[currentTrack]));
}

void draw() {
  int visuType = 0;
  if (visuType == 0) {
    copy(0, 0, width/2, height, -1, 0, width/2, height);
    copy(width/2, 0, width/2, height, width/2+1, 0, width/2, height);
    for (int ch = 0; ch < nbCh; ch++) {
      for (int bin = 0; bin < sL[frame].length; bin++) {
        float valueL = sL[frame][bin];
        float valueR = sR[frame][bin];
        fill(valueL*0x100);
        rect(width/2-1, height-(float)bin*height/sL[frame].length, 1, -(float)height/sL[frame].length);
        fill(valueR*0x100);
        rect(width/2, height-(float)bin*height/sL[frame].length, 1, -(float)height/sL[frame].length);
      }
    }
  }
  if (visuType == 1) {
    background(0);
    float hScale = 1.9f;
    float[] valueLInterp = new float[sL[0].length];
    float[] valueRInterp = new float[sL[0].length];
    for (int ch = 0; ch < nbCh; ch++) {
      for (int bin = 0; bin < sL[frame].length; bin++) {
        float valueL = sL[frame][bin];
        float valueR = sR[frame][bin];
        valueLInterp[bin]=lerp(valueLInterp[bin], valueL, valueL);
        valueRInterp[bin]=lerp(valueRInterp[bin], valueR, valueR);
        fill(0xFF);
        rect(width/2, height-bin*hScale, -valueLInterp[bin]*width/2, -hScale-1); 
        rect(width/2, height-bin*hScale, +valueRInterp[bin]*width/2, -hScale-1);
      }
    }
  }
  // saveFrame(dataPath("results/"+nf(currentTrack+1, 2)+"/"+nf(frame, 6)+".png"));
  frame++;
}

void initGenerate(String url) {
  println(url);
  track = minim.loadSample(url, 2048);
  sL = processArray(track.getChannel(AudioSample.LEFT));
  sR = processArray(track.getChannel(AudioSample.RIGHT));
  background(0);
  noStroke();
  frameRate(sL.length/((float)track.getChannel(AudioSample.LEFT).length/44100.0f));
  track.trigger();
  frame=0;
}

float[][] processArray(float[] channel) {
  int fftSize = 1024;
  float[] fftSamples = new float[fftSize];
  FFT fft = new FFT(fftSize, track.sampleRate());
  int totalChunks = (channel.length / fftSize) + 1;
  fft.logAverages(64, 36);
  // println(fft[i].avgSize()+" ");
  float[][] spectra = new float[totalChunks][fftSize/2];
  for (int chunkIdx = 0; chunkIdx < totalChunks; ++chunkIdx) {
    int chunkStartIndex = chunkIdx * fftSize;
    int chunkSize = min(channel.length - chunkStartIndex, fftSize);
    System.arraycopy(channel, chunkStartIndex, fftSamples, 0, chunkSize);
    if ( chunkSize < fftSize ) java.util.Arrays.fill(fftSamples, chunkSize, fftSamples.length - 1, 0.0 );
    fft.forward(fftSamples);
    for (int j = 0; j < fft.avgSize(); ++j) {
      float value = fft.getAvg(j);
      value /= 50;
      value = (value/(1+abs(value)));
      spectra[chunkIdx][j] = value;
    }
  }
  return spectra;
}
