
import rita.*;

void setup() {
  size(200, 200);
  RiTa rita = new RiTa();
  RiWordNet wordnet = new RiWordNet("C:\\Program Files (x86)\\WordNet\\2.1");
  RiLexicon lexicon = new RiLexicon();
  String[] txtDic = loadStrings(dataPath("rita_dict.txt"));
  for (String w : txtDic) {
    String[] wp = w.split("%");
    lexicon.addWord(wp[0], wp[1], wp[2]);
  }

  String sentence = "The quick brown fox jumps over the lazy dog !";
  println(sentence);
  for (int iter=0; iter<5; iter++) {
    String[] words = rita.tokenize(sentence);
    String[] tags = rita.getPosTags(sentence, true);
    sentence="";
    for (int i=0; i<words.length; i++) {
      String word = words[i];
      String tag = tags[i];
      if (lexicon.containsWord(word)) {
        if (!tag.equals("-")) {
          String[] synset = wordnet.getSynonyms(word, tags[i]);
          if (synset.length>0) {
            word = synset[floor(random(synset.length))];
          }
        }
      }
      sentence += word+" ";
    }
    println(sentence);
  }

  String[] rhymes = lexicon.rhymes("cat");
}

void draw() {
}
