
import processing.video.*;
Capture myCapture;

float gap = 7.4;
int zoom = 4;
int strokeW = 3;

void setup() {
  PImage im = loadImage("input1.png");
  size(im.width*zoom, im.height*zoom);
  myCapture = new Capture(this, floor((float)width/zoom), floor((float)height/zoom), Capture.list()[Capture.list().length-1], 5);
  displayMoireFrom(im);
}

void draw() {
}

void captureEvent(Capture myCapture) {
  myCapture.read();
  displayMoireFrom(myCapture);
}

void displayMoireFrom(PImage im) {
  for (int x=0;x<im.width*zoom;x++) {
    int phase=4;    
    for (int y=0;y<im.height*zoom;y++) {
      float offset = gap*brightness(im.get(x/zoom, y/zoom))/0xFF;
      if ((phase+offset)%gap<strokeW) stroke(0x00);
      else stroke(0xFF);
      point(x, y);
      phase++;
    }
  }
}

