
import processing.video.*;
Capture myCapture;

float gap = 7.4;
int zoom = 4;

PImage[] seq = new PImage[ceil(gap)];
int currentSeqIm = 0;

void setup() {
  PImage im = loadImage("input1.png");
  size(im.width*zoom, im.height*zoom);
  myCapture = new Capture(this, floor((float)width/zoom), floor((float)height/zoom), Capture.list()[0], 5);// Capture.list().length-1
}

void captureEvent(Capture myCapture) {
  if (keyPressed) {
    myCapture.read();
    seq[currentSeqIm%seq.length] = myCapture.get();
    println(currentSeqIm%seq.length);
    currentSeqIm++;
  }
}

void draw() {
  if (currentSeqIm>seq.length) displayMoireFrom(seq);
}

void displayMoireFrom(PImage[] seq) {
  for (int y=0;y<seq[0].height*zoom;y++) {
    int phase=0;    
    for (int x=0;x<seq[0].width*zoom;x++) {      
      int thisSeqIm = floor(phase%gap);
      if (brightness(seq[thisSeqIm].get(x/zoom, y/zoom))>0x80) stroke(lerpColor(color(0xFF), seq[thisSeqIm].get(x/zoom, y/zoom), 0.5));
      else stroke(lerpColor(color(0x00), seq[thisSeqIm].get(x/zoom, y/zoom), 0.5));
      point(x, y);
      phase++;
    }
  }
}

