
NeuralNetwork network;

public class NeuralNetwork {
  double LearnRate;
  double Momentum;
  ArrayList<Neuron> InputLayer;
  ArrayList<Neuron> HiddenLayer;
  ArrayList<Neuron> OutputLayer;

  public NeuralNetwork(int inputSize, int hiddenSize, int outputSize) {
    LearnRate = 0.001;
    Momentum = 0.8;
    InputLayer = new ArrayList<Neuron>();
    HiddenLayer = new ArrayList<Neuron>();
    OutputLayer = new ArrayList<Neuron>();

    for (int i = 0; i < inputSize; i++)
      InputLayer.add(new Neuron());

    for (int i = 0; i < hiddenSize; i++)
      HiddenLayer.add(new Neuron(InputLayer));

    for (int i = 0; i < outputSize; i++)
      OutputLayer.add(new Neuron(HiddenLayer));
  }

  public void Train(double[] inputs) {
    int i = 0;
    for (Neuron n : InputLayer) n.Value = inputs[i++];
    for (Neuron n : HiddenLayer) n.CalculateValue();
    for (Neuron n : OutputLayer) n.CalculateValue();
  }

  public double[] Compute(double[] inputs) {
    Train(inputs);
    double[] result = new double[OutputLayer.size()];
    for (int i=0; i<OutputLayer.size(); i++) result[i] = OutputLayer.get(i).Value;
    return result;
  }

  public double CalculateError(double[] targets) {
    int i = 0;
    double r = 0;
    for (Neuron n : OutputLayer) r+= abs((float)n.CalculateError(targets[i++]));
    return r;
  }

  public void BackPropagate(double[] targets) {
    int i = 0;
    for (Neuron n : OutputLayer) n.CalculateGradient(targets[i++]);
    for (Neuron n : HiddenLayer) n.CalculateGradient();
    for (Neuron n : HiddenLayer) n.UpdateWeights(LearnRate, Momentum);
    for (Neuron n : OutputLayer) n.UpdateWeights(LearnRate, Momentum);
  }

  double SigmoidFunction(double x) {
    return 1.0 / (1.0 + Math.exp(-x));
  }

  double SigmoidDerivative(double f) {
    return f * (1 - f);
  }
}

class Neuron {
  ArrayList<Synapse> InputSynapses;
  ArrayList<Synapse> OutputSynapses;
  double Bias;
  double BiasDelta;
  double Gradient;
  double Value;

  Neuron() {
    InputSynapses = new ArrayList<Synapse>();
    OutputSynapses = new ArrayList<Synapse>();
    Bias = random(-1, 1);
  }

  public Neuron(ArrayList<Neuron> inputNeurons) {
    this();
    for (Neuron inputNeuron : inputNeurons) {
      Synapse synapse = new Synapse(inputNeuron, this);
      inputNeuron.OutputSynapses.add(synapse);
      InputSynapses.add(synapse);
    }
  }

  double CalculateValue() {
    double r = 0;
    for (Synapse s : InputSynapses) r += s.Weight * s.InputNeuron.Value;
    return Value = network.SigmoidFunction(r + Bias);
  }

  public double CalculateDerivative() {
    return network.SigmoidDerivative(Value);
  }

  public double CalculateError(double target) {
    return target - Value;
  }

  public double CalculateGradient(double target) {
    return Gradient = CalculateError(target) * CalculateDerivative();
  }

  public double CalculateGradient() {
    double r=0;
    for (Synapse s : OutputSynapses) r += s.OutputNeuron.Gradient * s.Weight;
    return Gradient = r * CalculateDerivative();
  }

  public void UpdateWeights(double learnRate, double momentum) {
    double prevDelta = BiasDelta;
    BiasDelta = learnRate * Gradient; // * 1
    Bias += BiasDelta + momentum * prevDelta;

    for (Synapse s : InputSynapses) {
      prevDelta = s.WeightDelta;
      s.WeightDelta = learnRate * Gradient * s.InputNeuron.Value;
      s.Weight += s.WeightDelta + momentum * prevDelta;
    }
  }
}

class Synapse {
  public Neuron InputNeuron;
  public Neuron OutputNeuron;
  public double Weight;
  public double WeightDelta;
  Synapse(Neuron inputNeuron, Neuron outputNeuron) {
    InputNeuron = inputNeuron;
    OutputNeuron = outputNeuron;
    Weight = random(-1, 1);
  }
}

void saveState() {
  ArrayList<String> dataOut = new ArrayList<String>();
  
  // Save input layer
  for (Neuron neuron : network.InputLayer) {
    dataOut.add(str((float) neuron.Bias));
    dataOut.add(str((float) neuron.BiasDelta));
    dataOut.add(str((float) neuron.Gradient));
    dataOut.add(str((float) neuron.Value));
    for (Synapse synapse : neuron.OutputSynapses) {
      dataOut.add(str((float) synapse.Weight));
      dataOut.add(str((float) synapse.WeightDelta));
    }
  }

  // Save hidden layer
  for (Neuron neuron : network.HiddenLayer) {
    dataOut.add(str((float) neuron.Bias));
    dataOut.add(str((float) neuron.BiasDelta));
    dataOut.add(str((float) neuron.Gradient));
    dataOut.add(str((float) neuron.Value));
    for (Synapse synapse : neuron.OutputSynapses) {
      dataOut.add(str((float) synapse.Weight));
      dataOut.add(str((float) synapse.WeightDelta));
    }
  }

  // Save output layer
  for (Neuron neuron : network.OutputLayer) {
    dataOut.add(str((float) neuron.Bias));
    dataOut.add(str((float) neuron.BiasDelta));
    dataOut.add(str((float) neuron.Gradient));
    dataOut.add(str((float) neuron.Value));
  }

  saveStrings("data.txt", dataOut.toArray(new String[0]));
}

void loadState() {
  String[] dataIn = loadStrings("data.txt");
  if (dataIn == null) {
    println("No saved state found.");
    return;
  }
  
  int index = 0;
  
  // Load input layer
  for (Neuron neuron : network.InputLayer) {
    neuron.Bias = Double.parseDouble(dataIn[index++]);
    neuron.BiasDelta = Double.parseDouble(dataIn[index++]);
    neuron.Gradient = Double.parseDouble(dataIn[index++]);
    neuron.Value = Double.parseDouble(dataIn[index++]);
    for (Synapse synapse : neuron.OutputSynapses) {
      synapse.Weight = Double.parseDouble(dataIn[index++]);
      synapse.WeightDelta = Double.parseDouble(dataIn[index++]);
    }
  }

  // Load hidden layer
  for (Neuron neuron : network.HiddenLayer) {
    neuron.Bias = Double.parseDouble(dataIn[index++]);
    neuron.BiasDelta = Double.parseDouble(dataIn[index++]);
    neuron.Gradient = Double.parseDouble(dataIn[index++]);
    neuron.Value = Double.parseDouble(dataIn[index++]);
    for (Synapse synapse : neuron.OutputSynapses) {
      synapse.Weight = Double.parseDouble(dataIn[index++]);
      synapse.WeightDelta = Double.parseDouble(dataIn[index++]);
    }
  }

  // Load output layer
  for (Neuron neuron : network.OutputLayer) {
    neuron.Bias = Double.parseDouble(dataIn[index++]);
    neuron.BiasDelta = Double.parseDouble(dataIn[index++]);
    neuron.Gradient = Double.parseDouble(dataIn[index++]);
    neuron.Value = Double.parseDouble(dataIn[index++]);
  }

  println("Network state loaded");
}
