
int imgW = 80;
int imgH = 80;
float maxStrokeWeight = 20;

void setup() {
  size(300, 300);

  network = new NeuralNetwork(imgW*imgH*3*2, 150, 4+1+4);

  loadState();

  train();

  generate();
}

void draw() {
}

void generate() {
  PImage model = loadImage("model.jpg");
  PGraphics gr = createGraphics(model.width, model.height);
  gr.beginDraw();
  gr.background(0);
  gr.endDraw();
  int step=0;

  while (true) {
    int posX = floor(random(0, model.width-imgW));
    int posY = floor(random(0, model.height-imgH));
    PImage input = gr.get(posX, posY, imgW, imgH);
    PImage expectedOutput = model.get(posX, posY, imgW, imgH);
    double[] inputNeurons = new double[imgW*imgH*3*2];
    input.loadPixels();
    expectedOutput.loadPixels();
    for (int x=0; x<imgW; x++) {
      for (int y=0; y<imgH; y++) {
        inputNeurons[(x+y*imgW)*3*2+0] = red(input.pixels[x+y*imgW])/0xFF;
        inputNeurons[(x+y*imgW)*3*2+1] = green(input.pixels[x+y*imgW])/0xFF;
        inputNeurons[(x+y*imgW)*3*2+2] = blue(input.pixels[x+y*imgW])/0xFF;
        inputNeurons[(x+y*imgW)*3*2+3] = red(expectedOutput.pixels[x+y*imgW])/0xFF;
        inputNeurons[(x+y*imgW)*3*2+4] = green(expectedOutput.pixels[x+y*imgW])/0xFF;
        inputNeurons[(x+y*imgW)*3*2+5] = blue(expectedOutput.pixels[x+y*imgW])/0xFF;
      }
    }
    double[] outputs = network.Compute(inputNeurons);
    gr.beginDraw();
    gr.stroke((float)outputs[0]*0x100, (float)outputs[1]*0x100, (float)outputs[2]*0x100, (float)outputs[3]*0x100);
    gr.strokeWeight((float)outputs[4]*maxStrokeWeight);
    gr.line(posX+(float)outputs[5]*imgW, posY+(float)outputs[6]*imgH, posX+(float)outputs[7]*imgW, posY+(float)outputs[8]*imgH);
    gr.endDraw();
    if (step%100==0) gr.save("imitation/imit_"+nf(step, 7)+".png");
    step++;
  }
}

void train() {

  PGraphics gr = createGraphics(imgW, imgH);
  gr.beginDraw();
  gr.background(0);
  gr.endDraw();

  float avgError = 0;

  println("Training Network...");
  for (int i = 0; i < 1000000; i++)
  {
    gr.beginDraw();
    if (random(1)<0.01) gr.filter(BLUR, 1);
    if (random(1)<0.01) gr.background(0);
    if (random(1)<0.01) gr.background(0xFF);
    if (random(1)<0.01) gr.background(random(0xFF), random(0xFF), random(0xFF));
    gr.endDraw();
    PImage input = gr.get();
    double[] drawingParams = new double[4+1+4];
    for (int j=0; j<drawingParams.length; j++) drawingParams[j] = random(1);
    gr.beginDraw();
    gr.stroke((float)drawingParams[0]*0x100, (float)drawingParams[1]*0x100, (float)drawingParams[2]*0x100, (float)drawingParams[3]*0x100);
    gr.strokeWeight((float)drawingParams[4]*maxStrokeWeight);
    gr.line((float)drawingParams[5]*gr.width, (float)drawingParams[6]*gr.height, (float)drawingParams[7]*gr.width, (float)drawingParams[8]*gr.height);
    gr.endDraw();
    PImage expectedOutput = gr.get();
    double[] inputNeurons = new double[imgW*imgH*3*2];
    input.loadPixels();
    expectedOutput.loadPixels();
    for (int x=0; x<imgW; x++) {
      for (int y=0; y<imgH; y++) {
        inputNeurons[(x+y*imgW)*3*2+0] = red(input.pixels[x+y*imgW])/0xFF;
        inputNeurons[(x+y*imgW)*3*2+1] = green(input.pixels[x+y*imgW])/0xFF;
        inputNeurons[(x+y*imgW)*3*2+2] = blue(input.pixels[x+y*imgW])/0xFF;
        inputNeurons[(x+y*imgW)*3*2+3] = red(expectedOutput.pixels[x+y*imgW])/0xFF;
        inputNeurons[(x+y*imgW)*3*2+4] = green(expectedOutput.pixels[x+y*imgW])/0xFF;
        inputNeurons[(x+y*imgW)*3*2+5] = blue(expectedOutput.pixels[x+y*imgW])/0xFF;
      }
    }
    network.Train(inputNeurons);
    network.BackPropagate(drawingParams);
    avgError = lerp(avgError, (float)network.CalculateError(drawingParams), 0.1);
    if (i%100==0) {
      double[] outputs = network.Compute(inputNeurons);
      println("step "+i+" avgError "+avgError);
      gr.beginDraw();
      gr.image(input, 0, 0);
      gr.stroke((float)outputs[0]*0x100, (float)outputs[1]*0x100, (float)outputs[2]*0x100, (float)outputs[3]*0x100);
      gr.strokeWeight((float)outputs[4]*maxStrokeWeight);
      gr.line((float)outputs[5]*imgW, (float)outputs[6]*imgH, (float)outputs[7]*imgW, (float)outputs[8]*imgH);
      gr.endDraw();
      PImage imgOutput = gr.get();
      input.save("result/"+nf(i, 7)+"_input.png");
      expectedOutput.save("result/"+nf(i, 7)+"_expected.png");
      imgOutput.save("result/"+nf(i, 7)+"_output.png");
      saveState();
    }
  }
}
