
void setup() {
  size(500, 500);
  String[] files = getAllFilesFrom("D:/some/folder");
  for (String f : files) {
    PImage im = applyThreshold(loadImage(f), 200, 10);
    while (strPos(f, "\\")>=0) f = f.substring(strPos(f, "\\")+1, f.length());
    try {
      im.save(dataPath("result/"+f));
    } 
    catch (Exception e) {
      println(e);
    }
  }
}

PImage applyThreshold(PImage orig, int maxDist, int skip) {
  try {
    PImage im2 = createImage(orig.width, orig.height, RGB);
    im2.loadPixels();
    orig.loadPixels();
    float[] imR = new float[orig.pixels.length];
    float[] imG = new float[orig.pixels.length];
    float[] imB = new float[orig.pixels.length];
    for (int x=0; x<im2.width; x++) {
      for (int y=0; y<im2.height; y++) {
        imR[x+y*orig.width] = red(orig.pixels[x+y*orig.width]);
        imG[x+y*orig.width] = green(orig.pixels[x+y*orig.width]);
        imB[x+y*orig.width] = blue(orig.pixels[x+y*orig.width]);
      }
    }
    for (int x=0; x<im2.width; x++) {
      println(x+" / "+im2.width);
      for (int y=0; y<im2.height; y++) {
        float thisModifierR = 0;
        float thisModifierG = 0;
        float thisModifierB = 0;
        float totalModCoeffs = 0;
        for (int x2 = x-maxDist; x2 <= x+maxDist; x2+=skip) {
          for (int y2 = y-maxDist; y2 <= y+maxDist; y2+=skip) {
            if (x2>0&&x2<im2.width&&y2>0&&y2<im2.height && !(x==x2&&y==y2)) {
              float thisModCoeff = 1 / (sq(x2-x)+sq(y2-y));
              thisModifierR += imR[x2+y2*orig.width] * thisModCoeff;
              thisModifierG += imG[x2+y2*orig.width] * thisModCoeff;
              thisModifierB += imB[x2+y2*orig.width] * thisModCoeff;
              totalModCoeffs += thisModCoeff;
            }
          }
        }
        thisModifierR /= totalModCoeffs;
        thisModifierG /= totalModCoeffs;
        thisModifierB /= totalModCoeffs;
        im2.pixels[x+y*im2.width]=0x0;
        if (red(orig.pixels[x+y*orig.width])>thisModifierR) im2.pixels[x+y*im2.width]|=0xFF0000;
        if (green(orig.pixels[x+y*orig.width])>thisModifierG) im2.pixels[x+y*im2.width]|=0x00FF00;
        if (blue(orig.pixels[x+y*orig.width])>thisModifierB) im2.pixels[x+y*im2.width]|=0x0000FF;
      }
    }
    im2.updatePixels();
    return im2;
  } 
  catch(Exception e) {
    println(e);
    return null;
  }
}