/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import javax.swing.JOptionPane;
import processing.core.PApplet;

public class InterfaceA
extends Interface {
    public Shot lev;
    public Tileset tileset;
    public Map map;
    public MappingStats stat;
    int selectedTile;
    int gotoI = 0;

    public Shot getLev() {
        return this.lev;
    }

    public void setLev(Shot lev) {
        this.lev = lev;
    }

    public Tileset getTileset() {
        return this.tileset;
    }

    public void setTileset(Tileset tileset) {
        this.tileset = tileset;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public MappingStats getStat() {
        return this.stat;
    }

    public void setStat(MappingStats stat) {
        this.stat = stat;
    }

    public int getSelectedTile() {
        return this.selectedTile;
    }

    public void setSelectedTile(int selectedTile) {
        this.selectedTile = selectedTile;
    }

    InterfaceA(PApplet p) {
        super(p);
    }

    @Override
    public void setup() {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, "open screen", 0);
        fileDialog.setVisible(true);
        String userInput = JOptionPane.showInputDialog("Minimum tile size search : ");
        int sizeMin = Integer.parseInt(userInput);
        userInput = JOptionPane.showInputDialog("Maximum tile size search : ");
        int sizeMax = Integer.parseInt(userInput);
        String filePath = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
        this.lev = new Shot(this.parent, this.parent.dataPath(filePath));
        this.lev.investigateSetting(sizeMin, sizeMax);
        this.lev.chooseSettingFromList(this.lev.getlisteSetting(), -1);
        this.tileset = new Tileset(this.parent);
        this.tileset.addTiles(this.lev.getTileLists(), this.lev.gettS(), this.lev.getPalette());
        this.map = this.lev.generateMap(this.tileset);
        this.selectedTile = 1;
        this.parent.background(0);
        this.tileset.displayTypesMap(this.map);
        fileDialog = new FileDialog(frame, "save as", 1);
        fileDialog.setVisible(true);
        filePath = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
        this.tileset.outputFile(filePath);
        this.map.outputPng(filePath);
        this.map.outputTxt(filePath);
        MappingStats stat = new MappingStats(this.parent);
        stat = this.map.generateStats();
        stat.outputTxt(filePath);
        this.afficheBoutons();
    }

    @Override
    public void use() {
        if (this.parent.mousePressed) {
            if (this.fonctionSouris() == 1) {
                this.tileset.setTypeMouse(this.parent.mouseX, this.parent.mouseY, this.map, this.selectedTile);
                this.parent.background(0);
                this.tileset.displayTypesMap(this.map);
                this.afficheBoutons();
            }
            if (this.fonctionSouris() == 2) {
                this.selectedTile = PApplet.floor((float)this.parent.mouseX * (float)this.tileset.getnbTypes() / (float)this.parent.width);
                this.parent.background(0);
                this.tileset.displayTypesMap(this.map);
                this.afficheBoutons();
            }
            if (this.fonctionSouris() == 3) {
                this.deleteInvalid();
                this.stat = this.map.generateStats();
            }
        }
    }

    public int getGotoI() {
        return this.gotoI;
    }

    public void setGotoI(int gotoI) {
        this.gotoI = gotoI;
    }

    void display() {
        this.parent.background(0);
        this.tileset.display();
    }

    void afficheBoutons() {
        int nbT = this.tileset.getnbTypes();
        int i = 0;
        while (i < nbT) {
            ColorPx c = new ColorPx(Color.HSBtoRGB((float)i / (float)nbT, 1.0f, 1.0f));
            this.parent.stroke(c.getR(), c.getG(), c.getB());
            if (this.selectedTile == i) {
                this.parent.stroke(255);
            }
            this.parent.fill(c.getR(), c.getG(), c.getB(), 127.0f);
            this.parent.rect(i * this.parent.width / nbT, (float)this.map.gety() * this.tileset.gettS(), this.tileset.gettS(), this.tileset.gettS());
            this.parent.fill(255);
            float posX = i * this.parent.width / nbT;
            float posY = (float)(this.map.gety() + 1) * this.tileset.gettS();
            if (i == 0) {
                this.parent.text("nothing", posX, posY);
            } else if (i == 1) {
                this.parent.text("to be deleted", posX, posY);
            } else if (i == 2) {
                this.parent.text("wall", posX, posY);
            } else if (i == 3) {
                this.parent.text("background", posX, posY);
            } else if (i == 4) {
                this.parent.text("other", posX, posY);
            }
            ++i;
        }
    }

    private int fonctionSouris() {
        if ((float)this.parent.mouseY <= (float)this.map.gety() * this.tileset.gettS()) {
            return 1;
        }
        if ((float)this.parent.mouseY <= (float)(this.map.gety() + 1) * this.tileset.gettS()) {
            return 2;
        }
        return 3;
    }

    private void deleteInvalid() {
        int[] toShift = this.tileset.deleteInvalid();
        this.map.shift(toShift);
        this.parent.background(0);
        this.tileset.displayTypesMap(this.map);
    }
}

