/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import processing.core.PApplet;

public class InterfaceB
extends Interface {
    public Tileset tileset;
    public Map map;
    public MappingStats stat;
    int selectedTile;
    float tX = 10.0f;
    float tY = 10.0f;
    int tMapX = 5;
    int tMapY = 5;
    int gotoI = 0;

    public int getGotoI() {
        return this.gotoI;
    }

    public void setGotoI(int gotoI) {
        this.gotoI = gotoI;
    }

    public InterfaceB(TileUser p, InterfaceA if1) {
        super(p);
        this.tileset = if1.getTileset();
        this.stat = if1.getStat();
        this.map = new Map(p, this.tMapX, this.tMapY, if1.getMap().getNbIdent());
        this.map.setNbTypes(if1.getTileset().getnbTypes());
        this.map.setAllTypesTo(0);
        this.map.setAllIdentsTo(-1);
    }

    @Override
    void setup() {
        this.parent.background(0);
        this.map.displayTypes(this.tX, this.tY);
        this.afficheBoutons();
    }

    @Override
    void use() {
        if (this.parent.mousePressed) {
            if (this.fonctionSouris() == 1) {
                this.map.setTypeMouse((int)((float)this.parent.mouseX / this.tX), (int)((float)this.parent.mouseY / this.tY), this.selectedTile);
                this.parent.background(0);
                this.map.displayTypes(this.tX, this.tY);
                this.afficheBoutons();
            }
            if (this.fonctionSouris() == 2) {
                this.selectedTile = PApplet.floor((float)this.parent.mouseX * (float)this.tileset.getnbTypes() / (float)this.parent.width);
                this.parent.background(0);
                this.map.displayTypes(this.tX, this.tY);
                this.afficheBoutons();
            }
            if (this.fonctionSouris() == 3) {
                this.gotoI = 2;
                this.map.generateTiles(this.stat, this.tileset);
            }
        }
    }

    private void afficheBoutons() {
        int nbT = this.tileset.getnbTypes();
        int i = 0;
        while (i < nbT) {
            ColorPx c = new ColorPx(Color.HSBtoRGB((float)i / (float)nbT, 1.0f, 1.0f));
            this.parent.stroke(c.getR(), c.getG(), c.getB());
            if (this.selectedTile == i) {
                this.parent.stroke(255);
            }
            this.parent.fill(c.getR(), c.getG(), c.getB(), 127.0f);
            this.parent.rect(i * this.parent.width / nbT, (float)this.map.gety() * this.tY, this.tX, this.tY);
            this.parent.fill(255);
            float posX = i * this.parent.width / nbT;
            float posY = (float)(this.map.gety() + 1) * this.tY;
            if (i == 0) {
                this.parent.text("any", posX, posY);
            } else if (i == 1) {
                this.parent.text("empty", posX, posY);
            } else if (i == 2) {
                this.parent.text("wall", posX, posY);
            } else if (i == 3) {
                this.parent.text("background", posX, posY);
            } else if (i == 4) {
                this.parent.text("other", posX, posY);
            }
            ++i;
        }
    }

    private int fonctionSouris() {
        if ((float)this.parent.mouseY <= (float)this.map.gety() * this.tY) {
            return 1;
        }
        if ((float)this.parent.mouseY <= (float)(this.map.gety() + 1) * this.tY) {
            return 2;
        }
        if (this.parent.mouseX > this.parent.width / 2) {
            return 3;
        }
        return 4;
    }

    public void displayMapTiles() {
        this.parent.background(0);
        this.map.displayTiles(this.tileset);
    }
}

