/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PImage;

public class Map {
    PApplet parent;
    int x;
    int y;
    int[][] ident;
    int[][] type;
    int nbIdent;
    int nbTypes;

    public int getNbIdent() {
        return this.nbIdent;
    }

    public void setNbIdent(int nbIdent) {
        this.nbIdent = nbIdent;
    }

    Map(PApplet p, int x, int y, int nbIdent) {
        this.x = x;
        this.y = y;
        this.parent = p;
        this.ident = new int[x][y];
        this.nbIdent = nbIdent;
        this.type = new int[x][y];
        int xI = 0;
        while (xI < x) {
            int yI = 0;
            while (yI < y) {
                this.type[xI][yI] = -1;
                ++yI;
            }
            ++xI;
        }
    }

    public void setIdent(int x, int y, int i) {
        this.ident[x][y] = i;
    }

    public void outputTxt(String filePath) {
        String[] output = new String[this.y];
        int yI = 0;
        while (yI < this.y) {
            output[yI] = "";
            int xI = 0;
            while (xI < this.x) {
                int n = yI;
                output[n] = String.valueOf(output[n]) + PApplet.str(this.ident[xI][yI]);
                int n2 = yI;
                output[n2] = String.valueOf(output[n2]) + "\t";
                ++xI;
            }
            ++yI;
        }
        this.parent.saveStrings(String.valueOf(filePath) + "mapOutput.txt", output);
    }

    public void outputPng(String filePath) {
        ColorPx[] col = new ColorPx[this.nbIdent];
        int maxColor = 0xFFFFFF;
        int i = 0;
        while (i < this.nbIdent) {
            col[i] = new ColorPx(i * maxColor / this.nbIdent);
            ++i;
        }
        PImage map = new PImage(this.x, this.y);
        int yI = 0;
        while (yI < this.y) {
            int xI = 0;
            while (xI < this.x) {
                map.set(xI, yI, col[this.ident[xI][yI]].toInt());
                ++xI;
            }
            ++yI;
        }
        map.save(String.valueOf(filePath) + "map.png");
    }

    MappingStats generateStats() {
        MappingStats stats = new MappingStats(this.parent);
        int yI = 0;
        while (yI < this.y) {
            int xI = 0;
            while (xI < this.x) {
                int[] neigh = new int[]{this.tileIdentCheck(xI - 1, yI - 1), this.tileIdentCheck(xI + 0, yI - 1), this.tileIdentCheck(xI + 1, yI - 1), this.tileIdentCheck(xI - 1, yI + 0), this.tileIdentCheck(xI + 1, yI + 0), this.tileIdentCheck(xI - 1, yI + 1), this.tileIdentCheck(xI + 0, yI + 1), this.tileIdentCheck(xI + 1, yI + 1)};
                stats.tileIn(this.ident[xI][yI], neigh);
                ++xI;
            }
            ++yI;
        }
        return stats;
    }

    private int tileIdentCheck(int xC, int yC) {
        if (xC >= 0 && xC < this.x && yC >= 0 && yC < this.y) {
            return this.ident[xC][yC];
        }
        return -1;
    }

    public int getx() {
        return this.x;
    }

    public int gety() {
        return this.y;
    }

    public int getident(int x, int y) {
        return this.ident[x][y];
    }

    public void shift(int[] toShift) {
        int i = 0;
        while (i < toShift.length) {
            --this.nbIdent;
            int yI = 0;
            while (yI < this.y) {
                int xI = 0;
                while (xI < this.x) {
                    if (this.ident[xI][yI] > toShift[i]) {
                        int[] nArray = this.ident[xI];
                        int n = yI;
                        nArray[n] = nArray[n] - 1;
                    } else if (this.ident[xI][yI] == toShift[i]) {
                        this.ident[xI][yI] = -1;
                    }
                    ++xI;
                }
                ++yI;
            }
            ++i;
        }
    }

    public void displayTypes(float tx, float ty) {
        int xI = 0;
        while (xI < this.x) {
            int yI = 0;
            while (yI < this.y) {
                ColorPx c = new ColorPx(Color.HSBtoRGB((float)this.type[xI][yI] / (float)this.nbTypes, 1.0f, 1.0f));
                this.parent.stroke(c.getR(), c.getG(), c.getB());
                this.parent.fill(c.getR(), c.getG(), c.getB(), 127.0f);
                this.parent.rect((float)xI * tx, (float)yI * ty, tx, ty);
                ++yI;
            }
            ++xI;
        }
    }

    public int getNbTypes() {
        return this.nbTypes;
    }

    public void setNbTypes(int nbTypes) {
        this.nbTypes = nbTypes;
    }

    public void setTypeMouse(int f, int g, int sType) {
        if (f >= 0 && f < this.x && g >= 0 && g < this.y) {
            this.type[f][g] = sType;
        }
    }

    public void generateTiles(MappingStats stat, Tileset tileset) {
        this.setAllIdentsTo(-1);
        int[][][] possibleId = new int[this.x][this.y][];
        int xI = 0;
        while (xI < this.x) {
            int yI = 0;
            while (yI < this.y) {
                possibleId[xI][yI] = tileset.possibleIdentsFor(this.type[xI][yI]);
                ++yI;
            }
            ++xI;
        }
        Vector<int[][]> betterSets = new Vector<int[][]>();
        int lessDisturbance = -1;
        int[][] idTest = new int[this.x][this.y];
        int xI2 = 0;
        while (xI2 < this.x) {
            int yI = 0;
            while (yI < this.y) {
                idTest[xI2][yI] = 0;
                ++yI;
            }
            ++xI2;
        }
        int nbTotalSets = this.nbSets(possibleId);
        int currentTested = 0;
        while (!this.allPossibleSetsStudyied(idTest, possibleId) || betterSets.size() == 0) {
            System.out.println(String.valueOf((float)(++currentTested) / (float)nbTotalSets * 100.0f) + " %");
            idTest = this.nextPossibleSet(idTest, possibleId);
            int currentDisturbance = this.nbOfDisturbanceIn(idTest, possibleId, stat, lessDisturbance);
            if (currentDisturbance < lessDisturbance || betterSets.size() == 0) {
                lessDisturbance = currentDisturbance;
                betterSets.clear();
                betterSets.add(this.indexToValues(idTest, possibleId));
                continue;
            }
            if (currentDisturbance != lessDisturbance) continue;
            betterSets.add(this.indexToValues(idTest, possibleId));
        }
        System.out.println(betterSets.size());
        this.ident = (int[][])betterSets.get(betterSets.size() - 1);
    }

    private int nbSets(int[][][] possibleId) {
        int nbS = 1;
        int xI = 0;
        while (xI < this.x) {
            int yI = 0;
            while (yI < this.y) {
                nbS *= possibleId[xI][yI].length;
                ++yI;
            }
            ++xI;
        }
        return nbS;
    }

    private int[][] indexToValues(int[][] indexes, int[][][] possibleId) {
        int[][] idents = new int[indexes.length][indexes[0].length];
        int xI = 0;
        while (xI < this.x) {
            int yI = 0;
            while (yI < this.y) {
                idents[xI][yI] = possibleId[xI][yI][indexes[xI][yI]];
                ++yI;
            }
            ++xI;
        }
        return idents;
    }

    private int nbOfDisturbanceIn(int[][] idTest, int[][][] possibleId, MappingStats stat, int lessDisturbance) {
        idTest = this.indexToValues(idTest, possibleId);
        int nbDisturbance = 0;
        int xI = 0;
        while (xI < this.x) {
            int yI = 0;
            while (yI < this.y) {
                int[][] neighbors = new int[3][3];
                int xI2 = 0;
                while (xI2 < 3) {
                    int yI2 = 0;
                    while (yI2 < 3) {
                        int curX = xI + xI2 - 1;
                        int curY = yI + yI2 - 1;
                        neighbors[xI2][yI2] = curX >= 0 && curX < this.x && curY >= 0 && curY < this.y ? idTest[curX][curY] : -1;
                        ++yI2;
                    }
                    ++xI2;
                }
                if ((nbDisturbance += stat.nbDisturbanceIn(neighbors)) > lessDisturbance) {
                    return lessDisturbance + 1;
                }
                ++yI;
            }
            ++xI;
        }
        return nbDisturbance;
    }

    private int[][] nextPossibleSet(int[][] idTest, int[][][] possibleId) {
        boolean breakHere = false;
        int xI = 0;
        while (xI < this.x && !breakHere) {
            int yI = 0;
            while (yI < this.y && !breakHere) {
                if (idTest[xI][yI] < possibleId[xI][yI].length - 1) {
                    int[] nArray = idTest[xI];
                    int n = yI;
                    nArray[n] = nArray[n] + 1;
                    breakHere = true;
                } else {
                    idTest[xI][yI] = 0;
                }
                ++yI;
            }
            ++xI;
        }
        return idTest;
    }

    private boolean allPossibleSetsStudyied(int[][] idTest, int[][][] possibleId) {
        int xI = 0;
        while (xI < this.x) {
            int yI = 0;
            while (yI < this.y) {
                if (idTest[xI][yI] < possibleId[xI][yI].length - 1) {
                    return false;
                }
                ++yI;
            }
            ++xI;
        }
        return true;
    }

    public void displayTiles(Tileset tileset) {
        int xI = 0;
        while (xI < this.x) {
            int yI = 0;
            while (yI < this.y) {
                int tS = (int)tileset.gettS();
                tileset.displayTile(this.ident[xI][yI], xI * tS, yI * tS);
                ++yI;
            }
            ++xI;
        }
    }

    public void setAllTypesTo(int t) {
        int xI = 0;
        while (xI < this.x) {
            int yI = 0;
            while (yI < this.y) {
                this.type[xI][yI] = t;
                ++yI;
            }
            ++xI;
        }
    }

    public void setAllIdentsTo(int id) {
        int xI = 0;
        while (xI < this.x) {
            int yI = 0;
            while (yI < this.y) {
                this.ident[xI][yI] = id;
                ++yI;
            }
            ++xI;
        }
    }
}

