/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import processing.core.PApplet;

public class MappingStats {
    PApplet parent;
    Vector<MSTile> tiles = new Vector();

    MappingStats(PApplet p) {
        this.parent = p;
    }

    public void tileIn(int id, int[] neigh) {
        boolean trouve = false;
        int i = 0;
        while (i < this.tiles.size() && !trouve) {
            if (this.tiles.get(i).getIdent() == id) {
                trouve = true;
                MSTile tile = this.tiles.get(i);
                tile.addNeighbors(neigh);
                this.tiles.set(i, tile);
            }
            ++i;
        }
        if (!trouve) {
            MSTile tile = new MSTile(this.parent, id);
            tile.addNeighbors(neigh);
            this.tiles.add(tile);
        }
    }

    public void outputTxt(String filePath) {
        Vector<String> output = new Vector<String>();
        int i = 0;
        while (i < this.tiles.size()) {
            output.add("!");
            output.add(String.valueOf(this.tiles.get(i).getIdent()));
            output.add(String.valueOf(this.tiles.get(i).getOccur()));
            ++i;
        }
        String[] output2 = new String[output.size()];
        int i2 = 0;
        while (i2 < output.size()) {
            output2[i2] = (String)output.get(i2);
            ++i2;
        }
        this.parent.saveStrings(String.valueOf(filePath) + "statOutput.txt", output2);
    }

    public int nbDisturbanceIn(int[][] neighbors) {
        int dist = 0;
        if (neighbors[1][1] != -1) {
            int xI2 = 0;
            while (xI2 < 3) {
                int yI2 = 0;
                while (yI2 < 3) {
                    if (!(xI2 == 1 && yI2 == 1 || neighbors[xI2][yI2] == -1 || this.tiles.get(neighbors[1][1]).allowsIdAt(neighbors[xI2][yI2], xI2, yI2))) {
                        ++dist;
                    }
                    ++yI2;
                }
                ++xI2;
            }
        }
        return dist;
    }
}

