/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PImage;

public class Shot {
    PApplet parent;
    int tS;
    PImage im;
    int nbTX;
    int nbTY;
    int offsetX;
    int offsetY;
    Vector<ShotSetting> listeSettings = new Vector();
    Palette palette;
    int[][] pxIndex;

    Shot(PApplet p, String file) {
        this.parent = p;
        this.im = this.parent.loadImage(file);
        this.tS = 16;
        this.offsetX = 0;
        this.offsetY = 0;
        this.nbTX = (this.im.width - this.offsetX) / this.tS;
        this.nbTY = (this.im.height - this.offsetY) / this.tS;
        this.palette = new Palette();
        this.palette.loadPalette(this.im);
        this.pxIndex = this.palette.pictureToIndexes(this.im);
    }

    Shot(PApplet p, String file, int offsetX, int offsetY, int tS) {
        this.parent = p;
        this.tS = tS;
        this.im = this.parent.loadImage(file);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.nbTX = (this.im.width - offsetX) / tS;
        this.nbTY = (this.im.height - offsetY) / tS;
        this.palette = new Palette();
        this.palette.loadPalette(this.im);
        this.pxIndex = this.palette.pictureToIndexes(this.im);
    }

    void setTileSize(int tS) {
        this.tS = tS;
    }

    Map generateMap(Tileset tileset) {
        Map map = new Map(this.parent, this.nbTX, this.nbTY, tileset.getnbTiles());
        int y = 0;
        while (y < this.nbTY) {
            int x = 0;
            while (x < this.nbTX) {
                map.setIdent(x, y, tileset.searchInstanceOf(this.getTile(x * this.tS + this.offsetX, y * this.tS + this.offsetY, this.tS)));
                ++x;
            }
            ++y;
        }
        return map;
    }

    Tile getTile(int x, int y, int s) {
        Tile tile = new Tile(this.parent, s);
        tile.loadTile(this.pxIndex, x, y);
        return tile;
    }

    Tile[] getTileLists() {
        return this.getTileLists(this.offsetX, this.offsetY);
    }

    Tile[] getTileLists(int offsetX, int offsetY) {
        return this.getTileLists(offsetX, offsetY, this.tS, -1, -1);
    }

    Tile[] getTileLists(int offsetX, int offsetY, int tS, int maxiT, int maxiD) {
        int nbTX = (this.im.width - offsetX) / tS;
        int nbTY = (this.im.height - offsetY) / tS;
        int nbTMap = nbTX * nbTY;
        Vector<Tile> tiles = new Vector<Tile>();
        int y = 0;
        while (y < nbTY) {
            int x = 0;
            while (x < nbTX) {
                Tile tile = this.getTile(x * tS + offsetX, y * tS + offsetY, tS);
                boolean existe = false;
                int i = 0;
                while (i < tiles.size()) {
                    if (tile.equals((Tile)tiles.get(i))) {
                        existe = true;
                    }
                    ++i;
                }
                if (!existe) {
                    tiles.add(tile);
                    if (maxiT != -1 && tiles.size() > maxiT) {
                        return new Tile[0];
                    }
                    if (maxiD != -1 && (float)tiles.size() * PApplet.sq(tS) + (float)nbTMap > (float)maxiD) {
                        return new Tile[0];
                    }
                }
                ++x;
            }
            ++y;
        }
        Tile[] tilesA = new Tile[tiles.size()];
        int i = 0;
        while (i < tilesA.length) {
            tilesA[i] = (Tile)tiles.get(i);
            tilesA[i].setInstance(i);
            ++i;
        }
        return tilesA;
    }

    void investigateSetting(int minTS, int maxTS) {
        int maxSize = PApplet.min(this.im.width, this.im.height);
        if (maxTS == -1) {
            maxTS = maxSize;
        }
        Vector<ShotSetting> listeSettings = new Vector<ShotSetting>();
        int lessTData = this.im.width * this.im.height * 2;
        ShotSetting best = new ShotSetting(lessTData);
        int tSI = PApplet.max(minTS, 2);
        while (tSI <= PApplet.min(maxSize, maxTS) && PApplet.sq(tSI) < (float)lessTData) {
            System.out.println(String.valueOf(tSI) + " / " + PApplet.min(maxSize, maxTS));
            ShotSetting[][] allSettings = new ShotSetting[tSI][tSI];
            int nbTX = this.im.width / tSI;
            int nbTY = this.im.height / tSI;
            int lessTiles = nbTX * nbTY;
            int xC = 0;
            int yC = 0;
            int xI = 0;
            while (xI < tSI) {
                int yI = 0;
                while (yI < tSI) {
                    int tPI;
                    int essaiLength = this.getTileLists(xI, yI, tSI, lessTiles, -1).length;
                    allSettings[xI][yI] = new ShotSetting(xI, yI, essaiLength, tSI, this.im.width, this.im.height);
                    if (allSettings[xI][yI].getvalid() && (tPI = allSettings[xI][yI].getTotalPixels()) < allSettings[xC][yC].getTotalPixels()) {
                        lessTiles = essaiLength;
                        xC = xI;
                        yC = yI;
                    }
                    ++yI;
                }
                ++xI;
            }
            if (allSettings[xC][yC].getTotalData() < lessTData && allSettings[xC][yC].getvalid()) {
                best = allSettings[xC][yC];
                lessTData = best.getTotalData();
                listeSettings.add(best);
            }
            ++tSI;
        }
        this.listeSettings = listeSettings;
    }

    void chooseSettingFromList(Vector<ShotSetting> listeSetting, int choice) {
        if (choice == -1) {
            choice = 0;
            int i = 0;
            while (i < this.listeSettings.size()) {
                if (this.listeSettings.get(i).getTotalPixels() < this.listeSettings.get(choice).getTotalPixels()) {
                    choice = i;
                }
                ++i;
            }
        }
        this.tS = listeSetting.get(choice).gettS();
        this.offsetX = listeSetting.get(choice).getoffsetX();
        this.offsetY = listeSetting.get(choice).getoffsetY();
        this.nbTX = (this.im.width - this.offsetX) / this.tS;
        this.nbTY = (this.im.height - this.offsetY) / this.tS;
    }

    public int gettS() {
        return this.tS;
    }

    public Vector<ShotSetting> getlisteSetting() {
        return this.listeSettings;
    }

    public Palette getPalette() {
        return this.palette;
    }
}

