/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import processing.core.PApplet;

public class Tile {
    PApplet parent;
    private int tS;
    int inst;
    int[][] col;
    int type;

    Tile(PApplet p, int tS) {
        this.parent = p;
        this.tS = tS;
        this.col = new int[tS][tS];
        this.type = 0;
    }

    void setInstance(int inst) {
        this.inst = inst;
    }

    void loadTile(int[][] pxIndex, int xS, int yS) {
        int xI = 0;
        while (xI < this.tS) {
            int yI = 0;
            while (yI < this.tS) {
                this.col[xI][yI] = pxIndex[xS + xI][yS + yI];
                ++yI;
            }
            ++xI;
        }
    }

    boolean equals(Tile tile) {
        int xI = 0;
        while (xI < this.tS) {
            int yI = 0;
            while (yI < this.tS) {
                if (tile.getCol(xI, yI) != this.col[xI][yI]) {
                    return false;
                }
                ++yI;
            }
            ++xI;
        }
        return true;
    }

    void display(int x, int y, Palette palette) {
        int xI = 0;
        while (xI < this.tS) {
            int yI = 0;
            while (yI < this.tS) {
                ColorPx col2 = palette.colorOf(this.col[xI][yI]);
                int a = col2.getA();
                int r = col2.getR();
                int g = col2.getG();
                int b = col2.getB();
                this.parent.stroke(r, g, b, a);
                this.parent.point(x + xI, y + yI);
                ++yI;
            }
            ++xI;
        }
    }

    public void displayType(int i, int j, int nbTypes) {
        if (this.type != 0) {
            ColorPx c = new ColorPx(Color.HSBtoRGB((float)this.type / (float)nbTypes, 1.0f, 1.0f));
            this.parent.stroke(c.getR(), c.getG(), c.getB());
            this.parent.fill(c.getR(), c.getG(), c.getB(), 127.0f);
            this.parent.rect(i, j, this.tS, this.tS);
        }
    }

    public int getCol(int x, int y) {
        return this.col[x][y];
    }

    int getInst() {
        return this.inst;
    }

    public void incrementType(int nbTypes) {
        this.type = (this.type + 1) % nbTypes;
    }

    public void setType(int type2) {
        this.type = type2;
    }

    public int getType() {
        return this.type;
    }
}

