/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PImage;

public class Tileset {
    PApplet parent;
    Vector<Tile> tiles = new Vector();
    int tS;
    Palette palette;
    int nbTypes;

    Tileset(PApplet p) {
        this.parent = p;
        this.nbTypes = 5;
    }

    void addTiles(Tile[] tilesIn, int tS, Palette palette) {
        this.palette = palette;
        int i = 0;
        while (i < tilesIn.length) {
            this.tiles.add(tilesIn[i]);
            ++i;
        }
        this.tS = tS;
    }

    void display() {
        int nbTX = this.parent.width / this.tS;
        int i = 0;
        while (i < this.tiles.size()) {
            int x = i % nbTX * this.tS;
            int y = i / nbTX * this.tS;
            Tile tile = this.tiles.get(i);
            tile.display(x, y, this.palette);
            ++i;
        }
    }

    PImage display(int w, int h) {
        PImage display = new PImage(w, h);
        int nbTX = w / this.tS;
        int i = 0;
        while (i < this.tiles.size()) {
            if (i != -1) {
                int x = i % nbTX * this.tS;
                int y = i / nbTX * this.tS;
                int xI = 0;
                while (xI < this.tS) {
                    int yI = 0;
                    while (yI < this.tS) {
                        Tile tile = this.tiles.get(i);
                        int col = this.palette.colorOf(tile.getCol(xI, yI)).toInt();
                        display.set(xI + x, yI + y, col);
                        ++yI;
                    }
                    ++xI;
                }
            }
            ++i;
        }
        return display;
    }

    public int searchInstanceOf(Tile tile) {
        int i = 0;
        while (i < this.tiles.size()) {
            Tile tile2 = this.tiles.get(i);
            if (tile.equals(tile2)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void outputFile(String filePath) {
        PImage output = this.display(this.parent.width, this.parent.height);
        output.save(String.valueOf(filePath) + "Tileset.png");
    }

    int getnbTiles() {
        return this.tiles.size();
    }

    public void displayTypesMap(Map map) {
        int x = 0;
        while (x < map.getx()) {
            int y = 0;
            while (y < map.gety()) {
                if (map.getident(x, y) != -1) {
                    this.tiles.get(map.getident(x, y)).display(x * this.tS, y * this.tS, this.palette);
                    this.tiles.get(map.getident(x, y)).displayType(x * this.tS, y * this.tS, this.nbTypes);
                }
                ++y;
            }
            ++x;
        }
    }

    public void setTypeMouse(int mouseX, int mouseY, Map map, int type) {
        int x = PApplet.constrain(mouseX / this.tS, 0, map.getx() - 1);
        int y = PApplet.constrain(mouseY / this.tS, 0, map.gety() - 1);
        this.tiles.get(map.getident(x, y)).setType(type);
    }

    public int getnbTypes() {
        return this.nbTypes;
    }

    public float gettS() {
        return this.tS;
    }

    public int[] deleteInvalid() {
        Vector<Integer> toShift = new Vector<Integer>();
        int i = 0;
        while (i < this.tiles.size()) {
            if (this.tiles.get(i).getType() == 1) {
                this.tiles.remove(i);
                toShift.add(i);
                --i;
            }
            ++i;
        }
        int[] toShift2 = new int[toShift.size()];
        int i2 = 0;
        while (i2 < toShift.size()) {
            toShift2[i2] = (Integer)toShift.get(i2);
            ++i2;
        }
        return toShift2;
    }

    public void shiftTypes(int sh) {
        int i = 0;
        while (i < this.tiles.size()) {
            this.tiles.get(i).setType(this.tiles.get(i).getType() - sh);
            ++i;
        }
        this.nbTypes -= sh;
    }

    public int getTypeOfTile(int ident) {
        if (ident != -1) {
            return this.tiles.get(ident).getType();
        }
        return 1;
    }

    public void displayTile(int id, int x, int y) {
        int i = 0;
        while (i < this.tiles.size()) {
            if (this.tiles.get((int)i).inst == id) {
                this.tiles.get(id).display(x, y, this.palette);
            }
            ++i;
        }
    }

    public int[] possibleIdentsFor(int type) {
        Vector<Integer> possible = new Vector<Integer>();
        int i = 0;
        while (i < this.tiles.size()) {
            if (this.tiles.get(i).getType() == type || type == 0) {
                possible.add(i);
            }
            ++i;
        }
        if (possible.size() == 0) {
            possible.add(-1);
        }
        int[] possible2 = new int[possible.size()];
        int i2 = 0;
        while (i2 < possible.size()) {
            possible2[i2] = (Integer)possible.get(i2);
            ++i2;
        }
        return possible2;
    }
}

