/*
 * Decompiled with CFR 0.152.
 */
import drop.DropEvent;
import drop.SDrop;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.video.Capture;

public class tiler
extends PApplet {
    SDrop drop;
    PImage loadedPic;
    PImage origPic;
    PImage finalPic;
    ArrayList<Tile> tiPool = new ArrayList();
    int currentImPoolIndex = 0;
    int currentTiPoolIndex = 0;
    float borderSize;
    ArrayList<UIElement> uIElements = new ArrayList();
    float[] hDivs;
    float[] vDivs;
    boolean shiftPressed = false;
    boolean ctrlPressed = false;
    boolean tabPressed = false;
    int tileCutIntoX = 16;
    int tileCutIntoY = 16;
    int tileResultIntoX = 16;
    int tileResultIntoY = 16;
    int tileSubdivisions = 8;
    float finalBorderSize = 0.0f;
    float seeCuts = 2.0f;
    PImage cutsPic;
    PImage resultCutsPic;
    int nbResultsSaved = 0;
    boolean isCurrentlyProcessing = false;
    boolean isPendingProcess = false;
    int onlyUseTilesOnce = 0;
    Capture video;
    PApplet mainSketch;

    public void setup() {
        this.drop = new SDrop((PApplet)this);
        this.mainSketch = this;
        this.hDivs = this.divideLength(this.width, new float[]{2.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 5.0f});
        this.vDivs = this.divideLength(this.height, new float[]{2.0f, 5.0f, 5.0f, 5.0f, 30.0f, 30.0f, 5.0f});
        this.uIElements.add(new UIElementValue("divide x", this.hDivs[2], this.vDivs[1], this.tileCutIntoX, 1.0f, new Action(){

            @Override
            public void trigger(Object o) {
                ((UIElementValue)o).value = tiler.max((float)((UIElementValue)o).value, (float)1.0f);
                tiler.this.tileCutIntoX = tiler.floor((float)((UIElementValue)o).value);
                if (tiler.this.ctrlPressed && tiler.this.loadedPic != null) {
                    tiler.this.tileCutIntoY = tiler.round((float)((float)tiler.this.tileCutIntoX * (float)tiler.this.loadedPic.height / (float)tiler.this.loadedPic.width));
                    ((UIElementValue)tiler.this.getUIElement((String)"divide y")).value = tiler.this.tileCutIntoY;
                    tiler.this.computeCutsPic();
                }
                tiler.this.computeCutsPic();
            }
        }));
        this.uIElements.add(new UIElementValue("divide y", this.hDivs[2], this.vDivs[2], this.tileCutIntoY, 1.0f, new Action(){

            @Override
            public void trigger(Object o) {
                ((UIElementValue)o).value = tiler.max((float)((UIElementValue)o).value, (float)1.0f);
                tiler.this.tileCutIntoY = tiler.floor((float)((UIElementValue)o).value);
                if (tiler.this.ctrlPressed && tiler.this.loadedPic != null) {
                    tiler.this.tileCutIntoX = tiler.round((float)((float)tiler.this.tileCutIntoY * (float)tiler.this.loadedPic.width / (float)tiler.this.loadedPic.height));
                    ((UIElementValue)tiler.this.getUIElement((String)"divide x")).value = tiler.this.tileCutIntoX;
                    tiler.this.computeCutsPic();
                }
                tiler.this.computeCutsPic();
            }
        }));
        this.uIElements.add(new UIElementValue("see cuts", this.hDivs[3], this.vDivs[1], this.seeCuts, 1.0f, new Action(){

            @Override
            public void trigger(Object o) {
                tiler.this.seeCuts = ((UIElementValue)o).value;
                tiler.this.computeCutsPic();
                tiler.this.computeResultCutsPic();
            }
        }));
        this.uIElements.add(new UIElementValue("borders size", this.hDivs[8], this.vDivs[2], 0.0f, 1.0f, new Action(){

            @Override
            public void trigger(Object o) {
                ((UIElementValue)o).value = tiler.this.finalBorderSize = tiler.max((float)((UIElementValue)o).value, (float)0.0f);
                tiler.this.thread("process");
            }
        }));
        this.uIElements.add(new UIElement("process", this.hDivs[10], this.vDivs[1], new Action(){

            @Override
            public void trigger(Object o) {
                tiler.this.process();
            }
        }));
        this.uIElements.add(new UIElement("export", this.hDivs[10], this.vDivs[2], new Action(){

            @Override
            public void trigger(Object o) {
                File file = null;
                do {
                    if (!(file = new File(tiler.this.sketchPath("results/result" + tiler.nf((int)tiler.this.nbResultsSaved, (int)4) + ".png"))).exists()) continue;
                    ++tiler.this.nbResultsSaved;
                } while (file.exists());
                if (tiler.this.finalPic != null) {
                    tiler.this.finalPic.save("results/result" + tiler.nf((int)tiler.this.nbResultsSaved++, (int)4) + ".png");
                }
            }
        }));
        this.uIElements.add(new UIElement("load goal", this.hDivs[8], this.vDivs[1], new Action(){

            @Override
            public void trigger(Object o) {
                if (tiler.this.loadedPic != null) {
                    tiler.this.origPic = tiler.this.loadedPic;
                }
                tiler.this.computeResultCutsPic();
                tiler.this.process();
            }
        }));
        this.uIElements.add(new UIElement("load from cam", this.hDivs[3], this.vDivs[2], new Action(){

            @Override
            public void trigger(Object o) {
                if (tiler.this.video == null) {
                    tiler.this.video = new Capture(tiler.this.mainSketch);
                    tiler.this.video.start();
                }
                while (!tiler.this.video.available()) {
                    tiler.this.delay(1);
                }
                tiler.this.video.read();
                tiler.this.loadedPic = tiler.this.video.get();
                tiler.this.loadedPic.save(tiler.this.dataPath("pool/cam/camPic.png"));
                tiler.this.computeCutsPic();
            }
        }));
        this.uIElements.add(new UIElementValue("tile size x", this.hDivs[9], this.vDivs[1], this.tileResultIntoX, 1.0f, new Action(){

            @Override
            public void trigger(Object o) {
                ((UIElementValue)o).value = tiler.max((float)((UIElementValue)o).value, (float)1.0f);
                tiler.this.tileResultIntoX = tiler.floor((float)((UIElementValue)o).value);
                if (tiler.this.ctrlPressed && tiler.this.origPic != null) {
                    tiler.this.tileResultIntoY = tiler.round((float)((float)tiler.this.tileResultIntoX * (float)tiler.this.origPic.height / (float)tiler.this.origPic.width));
                    ((UIElementValue)tiler.this.getUIElement((String)"tile size y")).value = tiler.this.tileResultIntoY;
                }
                tiler.this.computeResultCutsPic();
                tiler.this.thread("process");
            }
        }));
        this.uIElements.add(new UIElementValue("tile size y", this.hDivs[9], this.vDivs[2], this.tileResultIntoY, 1.0f, new Action(){

            @Override
            public void trigger(Object o) {
                ((UIElementValue)o).value = tiler.max((float)((UIElementValue)o).value, (float)1.0f);
                tiler.this.tileResultIntoY = tiler.floor((float)((UIElementValue)o).value);
                if (tiler.this.ctrlPressed && tiler.this.origPic != null) {
                    tiler.this.tileResultIntoX = tiler.round((float)((float)tiler.this.tileResultIntoY * (float)tiler.this.origPic.width / (float)tiler.this.origPic.height));
                    ((UIElementValue)tiler.this.getUIElement((String)"tile size x")).value = tiler.this.tileResultIntoX;
                }
                tiler.this.computeResultCutsPic();
                tiler.this.thread("process");
            }
        }));
        this.uIElements.add(new UIElementValue("tile subdiv", this.hDivs[7], this.vDivs[1], this.tileSubdivisions, 1.0f, new Action(){

            @Override
            public void trigger(Object o) {
                ((UIElementValue)o).value = tiler.floor((float)tiler.max((float)((UIElementValue)o).value, (float)1.0f));
                tiler.this.tileSubdivisions = tiler.floor((float)((UIElementValue)o).value);
                for (Tile ti : tiler.this.tiPool) {
                    ti.computeAverages();
                }
                tiler.this.thread("process");
            }
        }));
        this.uIElements.add(new UIElementValue("once only", this.hDivs[7], this.vDivs[2], this.onlyUseTilesOnce, 1.0f, new Action(){

            @Override
            public void trigger(Object o) {
                tiler.this.onlyUseTilesOnce = (tiler.this.onlyUseTilesOnce + 1) % 2;
                ((UIElementValue)o).value = tiler.this.onlyUseTilesOnce;
                tiler.this.thread("process");
            }
        }));
        this.uIElements.add(new UIElement("clear tile pool", this.hDivs[6], this.vDivs[1], new Action(){

            @Override
            public void trigger(Object o) {
                tiler.this.tiPool.clear();
            }
        }));
        this.uIElements.add(new UIElement("add tiles", this.hDivs[6], this.vDivs[2], new Action(){

            @Override
            public void trigger(Object o) {
                tiler.this.thread("addTiles");
            }
        }));
    }

    public void draw() {
        if (this.isPendingProcess) {
            this.thread("process");
            this.isPendingProcess = false;
        }
        if (!this.isCurrentlyProcessing) {
            this.background(255);
            if (this.loadedPic != null) {
                this.imageFit(this.loadedPic, this.hDivs[2] + 2.0f, this.vDivs[4] + 2.0f, this.hDivs[5] - this.hDivs[2] - 4.0f, this.vDivs[6] - this.vDivs[4] - 4.0f, null);
            }
            if (this.cutsPic != null) {
                this.imageFit(this.cutsPic, this.hDivs[2] + 2.0f, this.vDivs[4] + 2.0f, this.hDivs[5] - this.hDivs[2] - 4.0f, this.vDivs[6] - this.vDivs[4] - 4.0f, null);
            }
            if (this.origPic != null) {
                this.imageFit(this.origPic, this.hDivs[8] + 2.0f, this.vDivs[4] + 2.0f, this.hDivs[8] - this.hDivs[5] - 4.0f, this.vDivs[5] - this.vDivs[4] - 4.0f, null);
            }
            if (this.resultCutsPic != null) {
                this.imageFit(this.resultCutsPic, this.hDivs[8] + 2.0f, this.vDivs[4] + 2.0f, this.hDivs[8] - this.hDivs[5] - 4.0f, this.vDivs[5] - this.vDivs[4] - 4.0f, null);
            }
            if (this.finalPic != null) {
                this.imageFit(this.finalPic, this.hDivs[8] + 2.0f, this.vDivs[5] + 2.0f, this.hDivs[8] - this.hDivs[5] - 4.0f, this.vDivs[6] - this.vDivs[5] - 4.0f, null);
            }
            if (this.tiPool.size() > 0) {
                float tileSizeX = this.tiPool.get((int)0).im.width;
                float tileSizeY = this.tiPool.get((int)0).im.height;
                if (this.origPic != null) {
                    tileSizeX = (float)this.origPic.width / (float)this.tileResultIntoX;
                    tileSizeY = (float)this.origPic.height / (float)this.tileResultIntoY;
                }
                float areaToFill = (this.hDivs[7] - this.hDivs[5]) * (this.vDivs[6] - this.vDivs[4] - 50.0f);
                float scaleToFit = tiler.sqrt((float)(areaToFill / ((float)this.tiPool.size() * (tileSizeX + 1.0f) * (tileSizeY + 1.0f))));
                tileSizeX *= scaleToFit;
                tileSizeY *= scaleToFit;
                float currentDrawX = this.hDivs[5];
                float currentDrawY = this.vDivs[4];
                int i = 0;
                while (i < this.tiPool.size()) {
                    this.image(this.tiPool.get((int)i).im, currentDrawX, currentDrawY, tileSizeX, tileSizeY);
                    currentDrawX += tileSizeX + 1.0f;
                    if (currentDrawX >= this.hDivs[7]) {
                        currentDrawX = this.hDivs[5];
                        currentDrawY += tileSizeY + 1.0f;
                    }
                    ++i;
                }
            }
            for (UIElement uIE : this.uIElements) {
                uIE.draw();
            }
            if (this.tabPressed && this.finalPic != null) {
                this.background(255);
                this.imageFit(this.finalPic, 0.0f, 0.0f, this.width, this.height, null);
            }
        }
    }

    public float[] divideLength(float l, float[] ds) {
        float[] fs = new float[ds.length];
        float t = 0.0f;
        float[] fArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            float d = fArray[n2];
            t += d;
            ++n2;
        }
        float cV = 0.0f;
        int i = 0;
        while (i < fs.length) {
            fs[i] = l * cV / t;
            cV += ds[i];
            ++i;
        }
        return fs;
    }

    public UIElement getUIElement(String s) {
        for (UIElement b : this.uIElements) {
            if (!b.name.equals(s)) continue;
            return b;
        }
        return null;
    }

    public void mousePressed() {
        for (UIElement uIE : this.uIElements) {
            uIE.clic(this.mouseX, this.mouseY);
        }
    }

    public void keyPressed() {
        if (this.keyCode == 16) {
            this.shiftPressed = true;
        }
        if (this.keyCode == 17) {
            this.ctrlPressed = true;
        }
        if (this.keyCode == 9) {
            this.tabPressed = true;
        }
    }

    public void keyReleased() {
        if (this.keyCode == 16) {
            this.shiftPressed = false;
        }
        if (this.keyCode == 17) {
            this.ctrlPressed = false;
        }
        if (this.keyCode == 9) {
            this.tabPressed = false;
        }
    }

    public void imageFit(PImage im, float x, float y, float w, float h, PGraphics gr) {
        float xScale = w / (float)im.width;
        float yScale = h / (float)im.height;
        float finalScale = tiler.min((float)xScale, (float)yScale);
        float finalSizeX = (float)im.width * finalScale;
        float finalSizeY = (float)im.height * finalScale;
        float internalPosX = (w - finalSizeX) / 2.0f;
        float internalPosY = (h - finalSizeY) / 2.0f;
        if (gr != null) {
            gr.image(im, x + internalPosX, y + internalPosY, finalSizeX, finalSizeY);
        } else {
            this.image(im, x + internalPosX, y + internalPosY, finalSizeX, finalSizeY);
        }
    }

    public void computeCutsPic() {
        if (this.seeCuts <= 0.0f) {
            this.cutsPic = null;
        } else if (this.loadedPic != null) {
            float scaledSeeCuts = this.seeCuts * tiler.max((float)((float)this.loadedPic.width / (this.hDivs[5] - this.hDivs[2] - 4.0f)), (float)((float)this.loadedPic.height / (this.vDivs[6] - this.vDivs[4] - 4.0f)));
            PGraphics temp = this.createGraphics(this.loadedPic.width, this.loadedPic.height, "processing.awt.PGraphicsJava2D");
            temp.beginDraw();
            temp.stroke(0);
            temp.strokeWeight(scaledSeeCuts);
            float x = 0.0f;
            while (x < (float)this.tileCutIntoX) {
                temp.line((float)temp.width * x / (float)this.tileCutIntoX, 0.0f, (float)temp.width * x / (float)this.tileCutIntoX, (float)temp.height);
                x += 1.0f;
            }
            float y = 0.0f;
            while (y < (float)this.tileCutIntoY) {
                temp.line(0.0f, (float)temp.height * y / (float)this.tileCutIntoY, (float)temp.width, (float)temp.height * y / (float)this.tileCutIntoY);
                y += 1.0f;
            }
            temp.endDraw();
            this.cutsPic = temp.get();
        }
    }

    public void computeResultCutsPic() {
        if (this.origPic != null) {
            float scaledSeeCuts = this.seeCuts * tiler.max((float)((float)this.origPic.width / (this.hDivs[8] - this.hDivs[5] - 4.0f)), (float)((float)this.origPic.height / (this.vDivs[5] - this.vDivs[4] - 4.0f)));
            PGraphics temp = this.createGraphics(this.origPic.width, this.origPic.height, "processing.awt.PGraphicsJava2D");
            temp.beginDraw();
            temp.stroke(0);
            temp.strokeWeight(scaledSeeCuts);
            float x = 0.0f;
            while (x < (float)this.tileResultIntoX) {
                temp.line((float)temp.width * x / (float)this.tileResultIntoX, 0.0f, (float)temp.width * x / (float)this.tileResultIntoX, (float)temp.height);
                x += 1.0f;
            }
            float y = 0.0f;
            while (y < (float)this.tileResultIntoY) {
                temp.line(0.0f, (float)temp.height * y / (float)this.tileResultIntoY, (float)temp.width, (float)temp.height * y / (float)this.tileResultIntoY);
                y += 1.0f;
            }
            temp.endDraw();
            this.resultCutsPic = temp.get();
        }
    }

    public void addTiles() {
        this.computeCutsPic();
        if (this.loadedPic == null) {
            return;
        }
        float y = 0.0f;
        while (y < (float)this.tileCutIntoY) {
            float x = 0.0f;
            while (x < (float)this.tileCutIntoX) {
                PImage thisTilePic = this.loadedPic.get(tiler.floor((float)(x * (float)this.loadedPic.width / (float)this.tileCutIntoX)), tiler.floor((float)(y * (float)this.loadedPic.height / (float)this.tileCutIntoY)), tiler.floor((float)(this.loadedPic.width / this.tileCutIntoX)), tiler.floor((float)(this.loadedPic.height / this.tileCutIntoY)));
                this.tiPool.add(new Tile(thisTilePic));
                x += 1.0f;
            }
            y += 1.0f;
        }
        this.process();
    }

    public void process() {
        int tileResultIntoXTmp = this.tileResultIntoX;
        int tileResultIntoYTmp = this.tileResultIntoY;
        int tileSubdivisionsTmp = this.tileSubdivisions;
        if (this.isCurrentlyProcessing) {
            this.isPendingProcess = true;
            return;
        }
        if (this.tiPool.size() == 0 || this.origPic == null) {
            return;
        }
        this.isCurrentlyProcessing = true;
        Tile[][] resultMap = new Tile[tileResultIntoXTmp][tileResultIntoYTmp];
        boolean[] used = new boolean[this.tiPool.size()];
        int i = 0;
        while (i < used.length) {
            used[i] = false;
            ++i;
        }
        int x = 0;
        while (x < tileResultIntoXTmp) {
            int y = 0;
            while (y < tileResultIntoYTmp) {
                int nbUnused = 0;
                int i2 = 0;
                while (i2 < used.length) {
                    if (!used[i2]) {
                        ++nbUnused;
                    }
                    ++i2;
                }
                if (nbUnused == 0) {
                    i2 = 0;
                    while (i2 < used.length) {
                        used[i2] = false;
                        ++i2;
                    }
                }
                PImage goal = this.origPic.get(tiler.floor((float)((float)x * (float)this.origPic.width / (float)tileResultIntoXTmp)), tiler.floor((float)((float)y * (float)this.origPic.height / (float)tileResultIntoYTmp)), tiler.floor((float)((float)this.origPic.width / (float)tileResultIntoXTmp)), tiler.floor((float)((float)this.origPic.height / (float)tileResultIntoYTmp)));
                int[][] thisAvgC = new int[tileSubdivisionsTmp][tileSubdivisionsTmp];
                int x3 = 0;
                while (x3 < tileSubdivisionsTmp) {
                    int y3 = 0;
                    while (y3 < tileSubdivisionsTmp) {
                        int thisColor = this.color(0);
                        int nbAdded = 0;
                        int x2 = tiler.floor((float)((float)goal.width * (float)x3 / (float)tileSubdivisionsTmp));
                        while (x2 < tiler.floor((float)((float)goal.width * (float)(x3 + 1) / (float)tileSubdivisionsTmp))) {
                            int y2 = tiler.floor((float)((float)goal.height * (float)y3 / (float)tileSubdivisionsTmp));
                            while (y2 < tiler.floor((float)((float)goal.height * (float)(y3 + 1) / (float)tileSubdivisionsTmp))) {
                                thisColor = this.lerpColor(goal.get(x2, y2), thisColor, nbAdded == 0 ? 0.0f : 1.0f / (float)nbAdded);
                                ++nbAdded;
                                ++y2;
                            }
                            ++x2;
                        }
                        thisAvgC[x3][y3] = thisColor;
                        ++y3;
                    }
                    ++x3;
                }
                float bestScore = -1.0f;
                Tile bestTile = null;
                int bestTileIndex = -1;
                int i3 = 0;
                while (i3 < this.tiPool.size()) {
                    float thisScore = this.computeScore(thisAvgC, this.tiPool.get((int)i3).avgC);
                    if (!(thisScore == -1.0f || bestScore != -1.0f && !(thisScore < bestScore) || used[i3] && this.onlyUseTilesOnce != 0)) {
                        bestScore = thisScore;
                        bestTile = this.tiPool.get(i3);
                        bestTileIndex = i3;
                    }
                    ++i3;
                }
                if (bestTileIndex != -1) {
                    used[bestTileIndex] = true;
                }
                resultMap[x][y] = bestTile;
                ++y;
            }
            ++x;
        }
        PGraphics result = this.createGraphics(this.origPic.width, this.origPic.height, "processing.awt.PGraphicsJava2D");
        result.beginDraw();
        PVector tSize = new PVector((float)tiler.floor((float)(result.width / tileResultIntoXTmp)), (float)tiler.floor((float)(result.height / tileResultIntoYTmp)));
        int x2 = 0;
        while (x2 < tileResultIntoXTmp) {
            int y = 0;
            while (y < tileResultIntoYTmp) {
                if (resultMap[x2][y] != null) {
                    result.image(resultMap[x2][y].im, tSize.x * (float)x2, tSize.y * (float)y, tSize.x, tSize.y);
                    if (this.finalBorderSize > 0.0f) {
                        result.noFill();
                        result.stroke(0);
                        result.strokeWeight(this.finalBorderSize);
                        result.rect(tSize.x * (float)x2, tSize.y * (float)y, tSize.x, tSize.y);
                    }
                }
                ++y;
            }
            ++x2;
        }
        result.endDraw();
        this.finalPic = result.get();
        this.isCurrentlyProcessing = false;
    }

    public float computeScore(int[][] a, int[][] b) {
        if (a.length == 0 || b.length == 0) {
            return -1.0f;
        }
        if (a.length != b.length || a[0].length != b[0].length) {
            return -1.0f;
        }
        float result = 0.0f;
        int x = 0;
        while (x < a.length) {
            int y = 0;
            while (y < a[x].length) {
                result += tiler.sqrt((float)(tiler.pow((float)(this.red(a[x][y]) - this.red(b[x][y])), (float)2.0f) + tiler.pow((float)(this.green(a[x][y]) - this.green(b[x][y])), (float)2.0f) + tiler.pow((float)(this.blue(a[x][y]) - this.blue(b[x][y])), (float)2.0f)));
                ++y;
            }
            ++x;
        }
        return result;
    }

    public void dropEvent(DropEvent theDropEvent) {
        try {
            this.loadedPic = this.loadImage(theDropEvent.file().getAbsolutePath());
            this.computeCutsPic();
        }
        catch (Exception e) {
            tiler.println((Object)e);
        }
    }

    public float vrMax(float a, float b, float m) {
        float d1 = b - a;
        if (d1 > m / 2.0f) {
            d1 -= m;
        }
        if (d1 < -m / 2.0f) {
            d1 += m;
        }
        return d1;
    }

    public String getDialogFileUrl(String label) {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, label, 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String filePath = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            return filePath;
        }
        return null;
    }

    public String getDialogFolderUrl(String label) {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, label, 0);
        fileDialog.setVisible(true);
        return fileDialog.getDirectory();
    }

    public String[] getDialogAllFilesUrl(String label) {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, label, 0);
        fileDialog.setVisible(true);
        return this.getAllFilesFrom(fileDialog.getDirectory());
    }

    public String[] getAllFilesFrom(String folderUrl) {
        File folder = new File(folderUrl);
        File[] filesPath = folder.listFiles();
        String[] result = new String[filesPath.length];
        int i = 0;
        while (i < filesPath.length) {
            result[i] = filesPath[i].toString();
            ++i;
        }
        return result;
    }

    public void renameFile(String urlA, String urlB) {
        File file2;
        File file = new File(this.sketchPath(urlA));
        boolean success = file.renameTo(file2 = new File(this.sketchPath(urlB)));
        if (!success) {
            tiler.println((String)(String.valueOf(urlA) + " was not renamed to " + urlB));
        }
    }

    public void copyDirectory(String urlA, String urlB) throws IOException {
        File srcDir = new File(this.sketchPath(urlA));
        File dstDir = new File(this.sketchPath(urlB));
        try {
            this.copyDirectoryRec(srcDir, dstDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copyDirectoryRec(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            int i = 0;
            while (i < children.length) {
                this.copyDirectoryRec(new File(srcDir, children[i]), new File(dstDir, children[i]));
                ++i;
            }
        } else {
            this.copyFile(srcDir, dstDir);
        }
    }

    public void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public PImage extractFromBackground(PImage entireCap, PImage background, float distoMask) {
        PImage mask = this.createImage(background.width, background.height, 1);
        PImage maskedCap = entireCap.get();
        int x = 0;
        while (x < background.width) {
            int y = 0;
            while (y < background.height) {
                int a = maskedCap.get(x, y);
                int b = background.get(x, y);
                mask.set(x, y, this.color(tiler.constrain((float)(tiler.abs((float)(this.red(a) - this.red(b))) * distoMask), (float)0.0f, (float)255.0f), tiler.constrain((float)(tiler.abs((float)(this.green(a) - this.green(b))) * distoMask), (float)0.0f, (float)255.0f), tiler.constrain((float)(tiler.abs((float)(this.blue(a) - this.blue(b))) * distoMask), (float)0.0f, (float)255.0f)));
                ++y;
            }
            ++x;
        }
        maskedCap.mask(mask);
        PGraphics maskedGraphics = this.createGraphics(maskedCap.width, maskedCap.height, "processing.awt.PGraphicsJava2D");
        maskedGraphics.beginDraw();
        maskedGraphics.image(maskedCap, 0.0f, 0.0f);
        maskedGraphics.endDraw();
        maskedCap = maskedGraphics.get();
        return maskedCap;
    }

    public String findAndReplace(String o, String f, String r) {
        int i = 0;
        while (i <= o.length() - f.length()) {
            if (o.substring(i, i + f.length()).equals(f)) {
                o = String.valueOf(o.substring(0, i)) + r + o.substring(i + f.length(), o.length());
                i += r.length() - 1;
            }
            ++i;
        }
        return o;
    }

    public int strPos(String haystack, String needle) {
        int i = 0;
        while (i <= haystack.length() - needle.length()) {
            if (haystack.substring(i, i + needle.length()).equals(needle)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[] loadStringsEnc(String url) {
        InputStream input = this.createInput(url);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(input, "ISO-8859-1"));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.exit();
        }
        String[] web = tiler.loadStrings(reader);
        return web;
    }

    public boolean contains(PVector[] points, PVector test) {
        boolean result = false;
        int i = 0;
        int j = points.length - 1;
        while (i < points.length) {
            if (points[i].y > test.y != points[j].y > test.y && test.x < (points[j].x - points[i].x) * (test.y - points[i].y) / (points[j].y - points[i].y) + points[i].x) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public boolean inArray(String[] hs, String n) {
        String[] stringArray = hs;
        int n2 = hs.length;
        int n3 = 0;
        while (n3 < n2) {
            String s = stringArray[n3];
            if (s.equals(n)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public int average(PImage img) {
        img.loadPixels();
        long r = 0L;
        long g = 0L;
        long b = 0L;
        int[] nArray = img.pixels;
        int n = img.pixels.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            r += (long)(c >> 16 & 0xFF);
            g += (long)(c >> 8 & 0xFF);
            b += (long)(c & 0xFF);
            ++n2;
        }
        return this.color((int)(r /= (long)img.pixels.length), (int)(g /= (long)img.pixels.length), (int)(b /= (long)img.pixels.length));
    }

    public void settings() {
        this.size(1500, 900);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"tiler"};
        if (passedArgs != null) {
            PApplet.main((String[])tiler.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    static interface Action {
        public void trigger(Object var1);
    }

    class Tile {
        PImage im;
        int[][] avgC;

        Tile(PImage im) {
            this.im = im;
            this.computeAverages();
        }

        public void computeAverages() {
            this.avgC = new int[tiler.this.tileSubdivisions][tiler.this.tileSubdivisions];
            int x = 0;
            while (x < tiler.this.tileSubdivisions) {
                int y = 0;
                while (y < tiler.this.tileSubdivisions) {
                    int thisColor = tiler.this.color(0);
                    int nbAdded = 0;
                    int x2 = tiler.floor((float)((float)this.im.width * (float)x / (float)tiler.this.tileSubdivisions));
                    while (x2 < tiler.floor((float)((float)this.im.width * (float)(x + 1) / (float)tiler.this.tileSubdivisions))) {
                        int y2 = tiler.floor((float)((float)this.im.height * (float)y / (float)tiler.this.tileSubdivisions));
                        while (y2 < tiler.floor((float)((float)this.im.height * (float)(y + 1) / (float)tiler.this.tileSubdivisions))) {
                            thisColor = tiler.this.lerpColor(this.im.get(x2, y2), thisColor, nbAdded == 0 ? 0.0f : 1.0f / (float)nbAdded);
                            ++nbAdded;
                            ++y2;
                        }
                        ++x2;
                    }
                    this.avgC[x][y] = thisColor;
                    ++y;
                }
                ++x;
            }
        }
    }

    class UIElement {
        String label = "";
        String name = "";
        PVector pos;
        PVector size = new PVector(125.0f, 30.0f);
        Action a;

        UIElement(String label, float x, float y, Action a) {
            this.label = label;
            this.name = label;
            this.pos = new PVector(x, y);
            this.a = a;
        }

        public void draw() {
            tiler.this.stroke(0);
            tiler.this.noFill();
            tiler.this.rect(this.pos.x, this.pos.y, this.size.x, this.size.y);
            tiler.this.fill(0);
            tiler.this.textSize(12.0f);
            tiler.this.text(this.label, this.pos.x + 10.0f, this.pos.y + 20.0f);
        }

        public void clic(int x, int y) {
            if ((float)x >= this.pos.x && (float)y >= this.pos.y && (float)x <= this.pos.x + this.size.x && (float)y <= this.pos.y + this.size.y) {
                this.typeTrigger();
                this.a.trigger(this);
            }
        }

        public void typeTrigger() {
        }
    }

    class UIElementValue
    extends UIElement {
        float value;
        float step;

        UIElementValue(String label, float x, float y, float value, float step, Action a) {
            super(label, x, y, a);
            this.value = value;
            this.step = step;
        }

        @Override
        public void draw() {
            tiler.this.stroke(0);
            tiler.this.noFill();
            tiler.this.rect(this.pos.x, this.pos.y, this.size.x, this.size.y);
            tiler.this.fill(0);
            tiler.this.textSize(12.0f);
            tiler.this.text(String.valueOf(this.label) + " " + tiler.floor((float)this.value), this.pos.x + 10.0f, this.pos.y + 20.0f);
        }

        @Override
        public void typeTrigger() {
            if (tiler.this.mouseButton == 39) {
                this.value -= this.step * (float)(tiler.this.shiftPressed ? 10 : 1);
            }
            if (tiler.this.mouseButton == 37) {
                this.value += this.step * (float)(tiler.this.shiftPressed ? 10 : 1);
            }
        }
    }
}

